/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.Address;

@SdkInternalApi
public class AddressMarshaller {
    private static final MarshallingInfo<String> STREETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streetName").build();
    private static final MarshallingInfo<String> STREETSUFFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streetSuffix").build();
    private static final MarshallingInfo<String> POSTDIRECTIONAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postDirectional").build();
    private static final MarshallingInfo<String> PREDIRECTIONAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("preDirectional").build();
    private static final MarshallingInfo<String> STREETNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streetNumber").build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("city").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postalCode").build();
    private static final MarshallingInfo<String> POSTALCODEPLUS4_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postalCodePlus4").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("country").build();
    private static final AddressMarshaller instance = new AddressMarshaller();

    public static AddressMarshaller getInstance() {
        return instance;
    }

    public void marshall(Address address, ProtocolMarshaller protocolMarshaller) {
        if (address == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)address.getStreetName(), STREETNAME_BINDING);
            protocolMarshaller.marshall((Object)address.getStreetSuffix(), STREETSUFFIX_BINDING);
            protocolMarshaller.marshall((Object)address.getPostDirectional(), POSTDIRECTIONAL_BINDING);
            protocolMarshaller.marshall((Object)address.getPreDirectional(), PREDIRECTIONAL_BINDING);
            protocolMarshaller.marshall((Object)address.getStreetNumber(), STREETNUMBER_BINDING);
            protocolMarshaller.marshall((Object)address.getCity(), CITY_BINDING);
            protocolMarshaller.marshall((Object)address.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)address.getPostalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)address.getPostalCodePlus4(), POSTALCODEPLUS4_BINDING);
            protocolMarshaller.marshall((Object)address.getCountry(), COUNTRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

