/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SearchRequestMarshaller
implements Marshaller<Request<SearchRequest>, SearchRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<SearchRequest> marshall(SearchRequest searchRequest) {
        String start;
        String sort;
        String size;
        String returnValue;
        String queryParser;
        String queryOptions;
        String query;
        String partial;
        String highlight;
        String filterQuery;
        String facet;
        String expr;
        String cursor;
        if (searchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)searchRequest, "AmazonCloudSearchDomain");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-01-01/search?format=sdk&pretty=true";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        String string = cursor = searchRequest.getCursor() == null ? null : StringUtils.fromString((String)searchRequest.getCursor());
        if (cursor != null) {
            request.addParameter("cursor", cursor);
        }
        String string2 = expr = searchRequest.getExpr() == null ? null : StringUtils.fromString((String)searchRequest.getExpr());
        if (expr != null) {
            request.addParameter("expr", expr);
        }
        String string3 = facet = searchRequest.getFacet() == null ? null : StringUtils.fromString((String)searchRequest.getFacet());
        if (facet != null) {
            request.addParameter("facet", facet);
        }
        String string4 = filterQuery = searchRequest.getFilterQuery() == null ? null : StringUtils.fromString((String)searchRequest.getFilterQuery());
        if (filterQuery != null) {
            request.addParameter("fq", filterQuery);
        }
        String string5 = highlight = searchRequest.getHighlight() == null ? null : StringUtils.fromString((String)searchRequest.getHighlight());
        if (highlight != null) {
            request.addParameter("highlight", highlight);
        }
        String string6 = partial = searchRequest.getPartial() == null ? null : StringUtils.fromBoolean((Boolean)searchRequest.getPartial());
        if (partial != null) {
            request.addParameter("partial", partial);
        }
        String string7 = query = searchRequest.getQuery() == null ? null : StringUtils.fromString((String)searchRequest.getQuery());
        if (query != null) {
            request.addParameter("q", query);
        }
        String string8 = queryOptions = searchRequest.getQueryOptions() == null ? null : StringUtils.fromString((String)searchRequest.getQueryOptions());
        if (queryOptions != null) {
            request.addParameter("q.options", queryOptions);
        }
        String string9 = queryParser = searchRequest.getQueryParser() == null ? null : StringUtils.fromString((String)searchRequest.getQueryParser());
        if (queryParser != null) {
            request.addParameter("q.parser", queryParser);
        }
        String string10 = returnValue = searchRequest.getReturn() == null ? null : StringUtils.fromString((String)searchRequest.getReturn());
        if (returnValue != null) {
            request.addParameter("return", returnValue);
        }
        String string11 = size = searchRequest.getSize() == null ? null : StringUtils.fromLong((Long)searchRequest.getSize());
        if (size != null) {
            request.addParameter("size", size);
        }
        String string12 = sort = searchRequest.getSort() == null ? null : StringUtils.fromString((String)searchRequest.getSort());
        if (sort != null) {
            request.addParameter("sort", sort);
        }
        String string13 = start = searchRequest.getStart() == null ? null : StringUtils.fromLong((Long)searchRequest.getStart());
        if (start != null) {
            request.addParameter("start", start);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

