/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.cloudtrail.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * EventSelectorMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class EventSelectorMarshaller {

    private static final MarshallingInfo<String> READWRITETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadWriteType").build();
    private static final MarshallingInfo<Boolean> INCLUDEMANAGEMENTEVENTS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeManagementEvents").build();
    private static final MarshallingInfo<List> DATARESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DataResources").build();
    private static final MarshallingInfo<List> EXCLUDEMANAGEMENTEVENTSOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeManagementEventSources").build();

    private static final EventSelectorMarshaller instance = new EventSelectorMarshaller();

    public static EventSelectorMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(EventSelector eventSelector, ProtocolMarshaller protocolMarshaller) {

        if (eventSelector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(eventSelector.getReadWriteType(), READWRITETYPE_BINDING);
            protocolMarshaller.marshall(eventSelector.getIncludeManagementEvents(), INCLUDEMANAGEMENTEVENTS_BINDING);
            protocolMarshaller.marshall(eventSelector.getDataResources(), DATARESOURCES_BINDING);
            protocolMarshaller.marshall(eventSelector.getExcludeManagementEventSources(), EXCLUDEMANAGEMENTEVENTSOURCES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
