/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnableAlarmActionsRequestMarshaller
implements Marshaller<Request<EnableAlarmActionsRequest>, EnableAlarmActionsRequest> {
    public Request<EnableAlarmActionsRequest> marshall(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        if (enableAlarmActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableAlarmActionsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "EnableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!enableAlarmActionsRequest.getAlarmNames().isEmpty() || !((SdkInternalList)enableAlarmActionsRequest.getAlarmNames()).isAutoConstruct()) {
            SdkInternalList alarmNamesList = (SdkInternalList)enableAlarmActionsRequest.getAlarmNames();
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        return request;
    }
}

