/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import com.amazonaws.services.cloudwatch.model.MetricStat;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class GetMetricDataRequestMarshaller
implements Marshaller<Request<GetMetricDataRequest>, GetMetricDataRequest> {
    public Request<GetMetricDataRequest> marshall(GetMetricDataRequest getMetricDataRequest) {
        if (getMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!getMetricDataRequest.getMetricDataQueries().isEmpty() || !((SdkInternalList)getMetricDataRequest.getMetricDataQueries()).isAutoConstruct()) {
            SdkInternalList metricDataQueriesList = (SdkInternalList)getMetricDataRequest.getMetricDataQueries();
            int metricDataQueriesListIndex = 1;
            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                if (metricDataQueriesListValue != null) {
                    MetricStat metricStat;
                    if (metricDataQueriesListValue.getId() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString((String)metricDataQueriesListValue.getId()));
                    }
                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                        Metric metric = metricStat.getMetric();
                        if (metric != null) {
                            if (metric.getNamespace() != null) {
                                request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                            }
                            if (metric.getMetricName() != null) {
                                request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                            }
                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                                int dimensionsListIndex = 1;
                                for (Dimension dimensionsListValue : dimensionsList) {
                                    if (dimensionsListValue != null) {
                                        if (dimensionsListValue.getName() != null) {
                                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                        }
                                        if (dimensionsListValue.getValue() != null) {
                                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                        }
                                    }
                                    ++dimensionsListIndex;
                                }
                            }
                        }
                        if (metricStat.getPeriod() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Period", StringUtils.fromInteger((Integer)metricStat.getPeriod()));
                        }
                        if (metricStat.getStat() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                        }
                        if (metricStat.getUnit() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                        }
                    }
                    if (metricDataQueriesListValue.getExpression() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString((String)metricDataQueriesListValue.getExpression()));
                    }
                    if (metricDataQueriesListValue.getLabel() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString((String)metricDataQueriesListValue.getLabel()));
                    }
                    if (metricDataQueriesListValue.getReturnData() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricDataQueriesListValue.getReturnData()));
                    }
                    if (metricDataQueriesListValue.getPeriod() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Period", StringUtils.fromInteger((Integer)metricDataQueriesListValue.getPeriod()));
                    }
                }
                ++metricDataQueriesListIndex;
            }
        }
        if (getMetricDataRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)getMetricDataRequest.getStartTime()));
        }
        if (getMetricDataRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)getMetricDataRequest.getEndTime()));
        }
        if (getMetricDataRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getMetricDataRequest.getNextToken()));
        }
        if (getMetricDataRequest.getScanBy() != null) {
            request.addParameter("ScanBy", StringUtils.fromString((String)getMetricDataRequest.getScanBy()));
        }
        if (getMetricDataRequest.getMaxDatapoints() != null) {
            request.addParameter("MaxDatapoints", StringUtils.fromInteger((Integer)getMetricDataRequest.getMaxDatapoints()));
        }
        return request;
    }
}

