/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codedeploy.model.InstanceTarget;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InstanceTargetMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").build();
    private static final MarshallingInfo<String> TARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetId").build();
    private static final MarshallingInfo<String> TARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> LIFECYCLEEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleEvents").build();
    private static final MarshallingInfo<String> INSTANCELABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceLabel").build();
    private static final InstanceTargetMarshaller instance = new InstanceTargetMarshaller();

    public static InstanceTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceTarget instanceTarget, ProtocolMarshaller protocolMarshaller) {
        if (instanceTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceTarget.getDeploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)instanceTarget.getTargetId(), TARGETID_BINDING);
            protocolMarshaller.marshall((Object)instanceTarget.getTargetArn(), TARGETARN_BINDING);
            protocolMarshaller.marshall((Object)instanceTarget.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceTarget.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(instanceTarget.getLifecycleEvents(), LIFECYCLEEVENTS_BINDING);
            protocolMarshaller.marshall((Object)instanceTarget.getInstanceLabel(), INSTANCELABEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

