/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehendmedical.model.Entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectPHIResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Entity> entities;
    private String paginationToken;

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<Entity> entities) {
        if (entities == null) {
            this.entities = null;
            return;
        }
        this.entities = new ArrayList<Entity>(entities);
    }

    public DetectPHIResult withEntities(Entity ... entities) {
        if (this.entities == null) {
            this.setEntities(new ArrayList<Entity>(entities.length));
        }
        for (Entity ele : entities) {
            this.entities.add(ele);
        }
        return this;
    }

    public DetectPHIResult withEntities(Collection<Entity> entities) {
        this.setEntities(entities);
        return this;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public DetectPHIResult withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntities() != null) {
            sb.append("Entities: ").append(this.getEntities()).append(",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: ").append(this.getPaginationToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectPHIResult)) {
            return false;
        }
        DetectPHIResult other = (DetectPHIResult)obj;
        if (other.getEntities() == null ^ this.getEntities() == null) {
            return false;
        }
        if (other.getEntities() != null && !other.getEntities().equals(this.getEntities())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        return other.getPaginationToken() == null || other.getPaginationToken().equals(this.getPaginationToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntities() == null ? 0 : this.getEntities().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        return hashCode;
    }

    public DetectPHIResult clone() {
        try {
            return (DetectPHIResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

