/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehendmedical.model.Entity;
import com.amazonaws.services.comprehendmedical.model.UnmappedAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectEntitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Entity> entities;
    private List<UnmappedAttribute> unmappedAttributes;
    private String paginationToken;
    private String modelVersion;

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<Entity> entities) {
        if (entities == null) {
            this.entities = null;
            return;
        }
        this.entities = new ArrayList<Entity>(entities);
    }

    public DetectEntitiesResult withEntities(Entity ... entities) {
        if (this.entities == null) {
            this.setEntities(new ArrayList<Entity>(entities.length));
        }
        for (Entity ele : entities) {
            this.entities.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withEntities(Collection<Entity> entities) {
        this.setEntities(entities);
        return this;
    }

    public List<UnmappedAttribute> getUnmappedAttributes() {
        return this.unmappedAttributes;
    }

    public void setUnmappedAttributes(Collection<UnmappedAttribute> unmappedAttributes) {
        if (unmappedAttributes == null) {
            this.unmappedAttributes = null;
            return;
        }
        this.unmappedAttributes = new ArrayList<UnmappedAttribute>(unmappedAttributes);
    }

    public DetectEntitiesResult withUnmappedAttributes(UnmappedAttribute ... unmappedAttributes) {
        if (this.unmappedAttributes == null) {
            this.setUnmappedAttributes(new ArrayList<UnmappedAttribute>(unmappedAttributes.length));
        }
        for (UnmappedAttribute ele : unmappedAttributes) {
            this.unmappedAttributes.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withUnmappedAttributes(Collection<UnmappedAttribute> unmappedAttributes) {
        this.setUnmappedAttributes(unmappedAttributes);
        return this;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public DetectEntitiesResult withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public DetectEntitiesResult withModelVersion(String modelVersion) {
        this.setModelVersion(modelVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntities() != null) {
            sb.append("Entities: ").append(this.getEntities()).append(",");
        }
        if (this.getUnmappedAttributes() != null) {
            sb.append("UnmappedAttributes: ").append(this.getUnmappedAttributes()).append(",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: ").append(this.getPaginationToken()).append(",");
        }
        if (this.getModelVersion() != null) {
            sb.append("ModelVersion: ").append(this.getModelVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResult)) {
            return false;
        }
        DetectEntitiesResult other = (DetectEntitiesResult)obj;
        if (other.getEntities() == null ^ this.getEntities() == null) {
            return false;
        }
        if (other.getEntities() != null && !other.getEntities().equals(this.getEntities())) {
            return false;
        }
        if (other.getUnmappedAttributes() == null ^ this.getUnmappedAttributes() == null) {
            return false;
        }
        if (other.getUnmappedAttributes() != null && !other.getUnmappedAttributes().equals(this.getUnmappedAttributes())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        if (other.getPaginationToken() != null && !other.getPaginationToken().equals(this.getPaginationToken())) {
            return false;
        }
        if (other.getModelVersion() == null ^ this.getModelVersion() == null) {
            return false;
        }
        return other.getModelVersion() == null || other.getModelVersion().equals(this.getModelVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntities() == null ? 0 : this.getEntities().hashCode());
        hashCode = 31 * hashCode + (this.getUnmappedAttributes() == null ? 0 : this.getUnmappedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        hashCode = 31 * hashCode + (this.getModelVersion() == null ? 0 : this.getModelVersion().hashCode());
        return hashCode;
    }

    public DetectEntitiesResult clone() {
        try {
            return (DetectEntitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

