/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.UserIdentityInfo;
import com.amazonaws.services.connect.model.UserPhoneConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateUserRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String username;
    private String password;
    private UserIdentityInfo identityInfo;
    private UserPhoneConfig phoneConfig;
    private String directoryUserId;
    private List<String> securityProfileIds;
    private String routingProfileId;
    private String hierarchyGroupId;
    private String instanceId;
    private Map<String, String> tags;

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public CreateUserRequest withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public CreateUserRequest withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public void setIdentityInfo(UserIdentityInfo identityInfo) {
        this.identityInfo = identityInfo;
    }

    public UserIdentityInfo getIdentityInfo() {
        return this.identityInfo;
    }

    public CreateUserRequest withIdentityInfo(UserIdentityInfo identityInfo) {
        this.setIdentityInfo(identityInfo);
        return this;
    }

    public void setPhoneConfig(UserPhoneConfig phoneConfig) {
        this.phoneConfig = phoneConfig;
    }

    public UserPhoneConfig getPhoneConfig() {
        return this.phoneConfig;
    }

    public CreateUserRequest withPhoneConfig(UserPhoneConfig phoneConfig) {
        this.setPhoneConfig(phoneConfig);
        return this;
    }

    public void setDirectoryUserId(String directoryUserId) {
        this.directoryUserId = directoryUserId;
    }

    public String getDirectoryUserId() {
        return this.directoryUserId;
    }

    public CreateUserRequest withDirectoryUserId(String directoryUserId) {
        this.setDirectoryUserId(directoryUserId);
        return this;
    }

    public List<String> getSecurityProfileIds() {
        return this.securityProfileIds;
    }

    public void setSecurityProfileIds(Collection<String> securityProfileIds) {
        if (securityProfileIds == null) {
            this.securityProfileIds = null;
            return;
        }
        this.securityProfileIds = new ArrayList<String>(securityProfileIds);
    }

    public CreateUserRequest withSecurityProfileIds(String ... securityProfileIds) {
        if (this.securityProfileIds == null) {
            this.setSecurityProfileIds(new ArrayList<String>(securityProfileIds.length));
        }
        for (String ele : securityProfileIds) {
            this.securityProfileIds.add(ele);
        }
        return this;
    }

    public CreateUserRequest withSecurityProfileIds(Collection<String> securityProfileIds) {
        this.setSecurityProfileIds(securityProfileIds);
        return this;
    }

    public void setRoutingProfileId(String routingProfileId) {
        this.routingProfileId = routingProfileId;
    }

    public String getRoutingProfileId() {
        return this.routingProfileId;
    }

    public CreateUserRequest withRoutingProfileId(String routingProfileId) {
        this.setRoutingProfileId(routingProfileId);
        return this;
    }

    public void setHierarchyGroupId(String hierarchyGroupId) {
        this.hierarchyGroupId = hierarchyGroupId;
    }

    public String getHierarchyGroupId() {
        return this.hierarchyGroupId;
    }

    public CreateUserRequest withHierarchyGroupId(String hierarchyGroupId) {
        this.setHierarchyGroupId(hierarchyGroupId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CreateUserRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateUserRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateUserRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateUserRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append(this.getPassword()).append(",");
        }
        if (this.getIdentityInfo() != null) {
            sb.append("IdentityInfo: ").append(this.getIdentityInfo()).append(",");
        }
        if (this.getPhoneConfig() != null) {
            sb.append("PhoneConfig: ").append(this.getPhoneConfig()).append(",");
        }
        if (this.getDirectoryUserId() != null) {
            sb.append("DirectoryUserId: ").append(this.getDirectoryUserId()).append(",");
        }
        if (this.getSecurityProfileIds() != null) {
            sb.append("SecurityProfileIds: ").append(this.getSecurityProfileIds()).append(",");
        }
        if (this.getRoutingProfileId() != null) {
            sb.append("RoutingProfileId: ").append(this.getRoutingProfileId()).append(",");
        }
        if (this.getHierarchyGroupId() != null) {
            sb.append("HierarchyGroupId: ").append(this.getHierarchyGroupId()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getIdentityInfo() == null ^ this.getIdentityInfo() == null) {
            return false;
        }
        if (other.getIdentityInfo() != null && !other.getIdentityInfo().equals(this.getIdentityInfo())) {
            return false;
        }
        if (other.getPhoneConfig() == null ^ this.getPhoneConfig() == null) {
            return false;
        }
        if (other.getPhoneConfig() != null && !other.getPhoneConfig().equals(this.getPhoneConfig())) {
            return false;
        }
        if (other.getDirectoryUserId() == null ^ this.getDirectoryUserId() == null) {
            return false;
        }
        if (other.getDirectoryUserId() != null && !other.getDirectoryUserId().equals(this.getDirectoryUserId())) {
            return false;
        }
        if (other.getSecurityProfileIds() == null ^ this.getSecurityProfileIds() == null) {
            return false;
        }
        if (other.getSecurityProfileIds() != null && !other.getSecurityProfileIds().equals(this.getSecurityProfileIds())) {
            return false;
        }
        if (other.getRoutingProfileId() == null ^ this.getRoutingProfileId() == null) {
            return false;
        }
        if (other.getRoutingProfileId() != null && !other.getRoutingProfileId().equals(this.getRoutingProfileId())) {
            return false;
        }
        if (other.getHierarchyGroupId() == null ^ this.getHierarchyGroupId() == null) {
            return false;
        }
        if (other.getHierarchyGroupId() != null && !other.getHierarchyGroupId().equals(this.getHierarchyGroupId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityInfo() == null ? 0 : this.getIdentityInfo().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneConfig() == null ? 0 : this.getPhoneConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryUserId() == null ? 0 : this.getDirectoryUserId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileIds() == null ? 0 : this.getSecurityProfileIds().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingProfileId() == null ? 0 : this.getRoutingProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getHierarchyGroupId() == null ? 0 : this.getHierarchyGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateUserRequest clone() {
        return (CreateUserRequest)super.clone();
    }
}

