/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.CurrentMetric;
import com.amazonaws.services.connect.model.Filters;
import com.amazonaws.services.connect.model.Grouping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetCurrentMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private Filters filters;
    private List<String> groupings;
    private List<CurrentMetric> currentMetrics;
    private String nextToken;
    private Integer maxResults;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public GetCurrentMetricDataRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public GetCurrentMetricDataRequest withFilters(Filters filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(Collection<String> groupings) {
        if (groupings == null) {
            this.groupings = null;
            return;
        }
        this.groupings = new ArrayList<String>(groupings);
    }

    public GetCurrentMetricDataRequest withGroupings(String ... groupings) {
        if (this.groupings == null) {
            this.setGroupings(new ArrayList<String>(groupings.length));
        }
        for (String ele : groupings) {
            this.groupings.add(ele);
        }
        return this;
    }

    public GetCurrentMetricDataRequest withGroupings(Collection<String> groupings) {
        this.setGroupings(groupings);
        return this;
    }

    public GetCurrentMetricDataRequest withGroupings(Grouping ... groupings) {
        ArrayList<String> groupingsCopy = new ArrayList<String>(groupings.length);
        for (Grouping value : groupings) {
            groupingsCopy.add(value.toString());
        }
        if (this.getGroupings() == null) {
            this.setGroupings(groupingsCopy);
        } else {
            this.getGroupings().addAll(groupingsCopy);
        }
        return this;
    }

    public List<CurrentMetric> getCurrentMetrics() {
        return this.currentMetrics;
    }

    public void setCurrentMetrics(Collection<CurrentMetric> currentMetrics) {
        if (currentMetrics == null) {
            this.currentMetrics = null;
            return;
        }
        this.currentMetrics = new ArrayList<CurrentMetric>(currentMetrics);
    }

    public GetCurrentMetricDataRequest withCurrentMetrics(CurrentMetric ... currentMetrics) {
        if (this.currentMetrics == null) {
            this.setCurrentMetrics(new ArrayList<CurrentMetric>(currentMetrics.length));
        }
        for (CurrentMetric ele : currentMetrics) {
            this.currentMetrics.add(ele);
        }
        return this;
    }

    public GetCurrentMetricDataRequest withCurrentMetrics(Collection<CurrentMetric> currentMetrics) {
        this.setCurrentMetrics(currentMetrics);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetCurrentMetricDataRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetCurrentMetricDataRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getGroupings() != null) {
            sb.append("Groupings: ").append(this.getGroupings()).append(",");
        }
        if (this.getCurrentMetrics() != null) {
            sb.append("CurrentMetrics: ").append(this.getCurrentMetrics()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentMetricDataRequest)) {
            return false;
        }
        GetCurrentMetricDataRequest other = (GetCurrentMetricDataRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getGroupings() == null ^ this.getGroupings() == null) {
            return false;
        }
        if (other.getGroupings() != null && !other.getGroupings().equals(this.getGroupings())) {
            return false;
        }
        if (other.getCurrentMetrics() == null ^ this.getCurrentMetrics() == null) {
            return false;
        }
        if (other.getCurrentMetrics() != null && !other.getCurrentMetrics().equals(this.getCurrentMetrics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getGroupings() == null ? 0 : this.getGroupings().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentMetrics() == null ? 0 : this.getCurrentMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public GetCurrentMetricDataRequest clone() {
        return (GetCurrentMetricDataRequest)super.clone();
    }
}

