/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.Reference;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateContactRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String contactId;
    private String name;
    private String description;
    private Map<String, Reference> references;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public UpdateContactRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public String getContactId() {
        return this.contactId;
    }

    public UpdateContactRequest withContactId(String contactId) {
        this.setContactId(contactId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateContactRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateContactRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, Reference> getReferences() {
        return this.references;
    }

    public void setReferences(Map<String, Reference> references) {
        this.references = references;
    }

    public UpdateContactRequest withReferences(Map<String, Reference> references) {
        this.setReferences(references);
        return this;
    }

    public UpdateContactRequest addReferencesEntry(String key, Reference value) {
        if (null == this.references) {
            this.references = new HashMap<String, Reference>();
        }
        if (this.references.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.references.put(key, value);
        return this;
    }

    public UpdateContactRequest clearReferencesEntries() {
        this.references = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getContactId() != null) {
            sb.append("ContactId: ").append(this.getContactId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getReferences() != null) {
            sb.append("References: ").append(this.getReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getContactId() == null ^ this.getContactId() == null) {
            return false;
        }
        if (other.getContactId() != null && !other.getContactId().equals(this.getContactId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getReferences() == null ^ this.getReferences() == null) {
            return false;
        }
        return other.getReferences() == null || other.getReferences().equals(this.getReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getContactId() == null ? 0 : this.getContactId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getReferences() == null ? 0 : this.getReferences().hashCode());
        return hashCode;
    }

    public UpdateContactRequest clone() {
        return (UpdateContactRequest)super.clone();
    }
}

