/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcases.model.FieldValue;
import com.amazonaws.services.connectcases.model.transform.SearchCasesResponseItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchCasesResponseItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String caseId;
    private List<FieldValue> fields;
    private Map<String, String> tags;
    private String templateId;

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public SearchCasesResponseItem withCaseId(String caseId) {
        this.setCaseId(caseId);
        return this;
    }

    public List<FieldValue> getFields() {
        return this.fields;
    }

    public void setFields(Collection<FieldValue> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<FieldValue>(fields);
    }

    public SearchCasesResponseItem withFields(FieldValue ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<FieldValue>(fields.length));
        }
        for (FieldValue ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public SearchCasesResponseItem withFields(Collection<FieldValue> fields) {
        this.setFields(fields);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SearchCasesResponseItem withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SearchCasesResponseItem addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SearchCasesResponseItem clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public SearchCasesResponseItem withTemplateId(String templateId) {
        this.setTemplateId(templateId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCaseId() != null) {
            sb.append("CaseId: ").append(this.getCaseId()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTemplateId() != null) {
            sb.append("TemplateId: ").append(this.getTemplateId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesResponseItem)) {
            return false;
        }
        SearchCasesResponseItem other = (SearchCasesResponseItem)obj;
        if (other.getCaseId() == null ^ this.getCaseId() == null) {
            return false;
        }
        if (other.getCaseId() != null && !other.getCaseId().equals(this.getCaseId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTemplateId() == null ^ this.getTemplateId() == null) {
            return false;
        }
        return other.getTemplateId() == null || other.getTemplateId().equals(this.getTemplateId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCaseId() == null ? 0 : this.getCaseId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateId() == null ? 0 : this.getTemplateId().hashCode());
        return hashCode;
    }

    public SearchCasesResponseItem clone() {
        try {
            return (SearchCasesResponseItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchCasesResponseItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

