/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcontactlens.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcontactlens.model.IssueDetected;
import com.amazonaws.services.connectcontactlens.model.SentimentValue;
import com.amazonaws.services.connectcontactlens.model.transform.TranscriptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Transcript
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String participantId;
    private String participantRole;
    private String content;
    private Integer beginOffsetMillis;
    private Integer endOffsetMillis;
    private String sentiment;
    private List<IssueDetected> issuesDetected;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Transcript withId(String id) {
        this.setId(id);
        return this;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public Transcript withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public void setParticipantRole(String participantRole) {
        this.participantRole = participantRole;
    }

    public String getParticipantRole() {
        return this.participantRole;
    }

    public Transcript withParticipantRole(String participantRole) {
        this.setParticipantRole(participantRole);
        return this;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public Transcript withContent(String content) {
        this.setContent(content);
        return this;
    }

    public void setBeginOffsetMillis(Integer beginOffsetMillis) {
        this.beginOffsetMillis = beginOffsetMillis;
    }

    public Integer getBeginOffsetMillis() {
        return this.beginOffsetMillis;
    }

    public Transcript withBeginOffsetMillis(Integer beginOffsetMillis) {
        this.setBeginOffsetMillis(beginOffsetMillis);
        return this;
    }

    public void setEndOffsetMillis(Integer endOffsetMillis) {
        this.endOffsetMillis = endOffsetMillis;
    }

    public Integer getEndOffsetMillis() {
        return this.endOffsetMillis;
    }

    public Transcript withEndOffsetMillis(Integer endOffsetMillis) {
        this.setEndOffsetMillis(endOffsetMillis);
        return this;
    }

    public void setSentiment(String sentiment) {
        this.sentiment = sentiment;
    }

    public String getSentiment() {
        return this.sentiment;
    }

    public Transcript withSentiment(String sentiment) {
        this.setSentiment(sentiment);
        return this;
    }

    public Transcript withSentiment(SentimentValue sentiment) {
        this.sentiment = sentiment.toString();
        return this;
    }

    public List<IssueDetected> getIssuesDetected() {
        return this.issuesDetected;
    }

    public void setIssuesDetected(Collection<IssueDetected> issuesDetected) {
        if (issuesDetected == null) {
            this.issuesDetected = null;
            return;
        }
        this.issuesDetected = new ArrayList<IssueDetected>(issuesDetected);
    }

    public Transcript withIssuesDetected(IssueDetected ... issuesDetected) {
        if (this.issuesDetected == null) {
            this.setIssuesDetected(new ArrayList<IssueDetected>(issuesDetected.length));
        }
        for (IssueDetected ele : issuesDetected) {
            this.issuesDetected.add(ele);
        }
        return this;
    }

    public Transcript withIssuesDetected(Collection<IssueDetected> issuesDetected) {
        this.setIssuesDetected(issuesDetected);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getParticipantId() != null) {
            sb.append("ParticipantId: ").append(this.getParticipantId()).append(",");
        }
        if (this.getParticipantRole() != null) {
            sb.append("ParticipantRole: ").append(this.getParticipantRole()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getBeginOffsetMillis() != null) {
            sb.append("BeginOffsetMillis: ").append(this.getBeginOffsetMillis()).append(",");
        }
        if (this.getEndOffsetMillis() != null) {
            sb.append("EndOffsetMillis: ").append(this.getEndOffsetMillis()).append(",");
        }
        if (this.getSentiment() != null) {
            sb.append("Sentiment: ").append(this.getSentiment()).append(",");
        }
        if (this.getIssuesDetected() != null) {
            sb.append("IssuesDetected: ").append(this.getIssuesDetected());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getParticipantId() == null ^ this.getParticipantId() == null) {
            return false;
        }
        if (other.getParticipantId() != null && !other.getParticipantId().equals(this.getParticipantId())) {
            return false;
        }
        if (other.getParticipantRole() == null ^ this.getParticipantRole() == null) {
            return false;
        }
        if (other.getParticipantRole() != null && !other.getParticipantRole().equals(this.getParticipantRole())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getBeginOffsetMillis() == null ^ this.getBeginOffsetMillis() == null) {
            return false;
        }
        if (other.getBeginOffsetMillis() != null && !other.getBeginOffsetMillis().equals(this.getBeginOffsetMillis())) {
            return false;
        }
        if (other.getEndOffsetMillis() == null ^ this.getEndOffsetMillis() == null) {
            return false;
        }
        if (other.getEndOffsetMillis() != null && !other.getEndOffsetMillis().equals(this.getEndOffsetMillis())) {
            return false;
        }
        if (other.getSentiment() == null ^ this.getSentiment() == null) {
            return false;
        }
        if (other.getSentiment() != null && !other.getSentiment().equals(this.getSentiment())) {
            return false;
        }
        if (other.getIssuesDetected() == null ^ this.getIssuesDetected() == null) {
            return false;
        }
        return other.getIssuesDetected() == null || other.getIssuesDetected().equals(this.getIssuesDetected());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantId() == null ? 0 : this.getParticipantId().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantRole() == null ? 0 : this.getParticipantRole().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getBeginOffsetMillis() == null ? 0 : this.getBeginOffsetMillis().hashCode());
        hashCode = 31 * hashCode + (this.getEndOffsetMillis() == null ? 0 : this.getEndOffsetMillis().hashCode());
        hashCode = 31 * hashCode + (this.getSentiment() == null ? 0 : this.getSentiment().hashCode());
        hashCode = 31 * hashCode + (this.getIssuesDetected() == null ? 0 : this.getIssuesDetected().hashCode());
        return hashCode;
    }

    public Transcript clone() {
        try {
            return (Transcript)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TranscriptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

