/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectwisdom.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connectwisdom.model.DocumentText;
import java.util.List;

@SdkInternalApi
public class DocumentTextMarshaller {
    private static final MarshallingInfo<List> HIGHLIGHTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("highlights").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("text").build();
    private static final DocumentTextMarshaller instance = new DocumentTextMarshaller();

    public static DocumentTextMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentText documentText, ProtocolMarshaller protocolMarshaller) {
        if (documentText == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(documentText.getHighlights(), HIGHLIGHTS_BINDING);
            protocolMarshaller.marshall((Object)documentText.getText(), TEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

