/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.rpcv2cbor;

import com.amazonaws.http.RpcV2CborErrorResponseHandler;
import com.amazonaws.http.RpcV2CborResponseHandler;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorMessageParser;
import com.amazonaws.protocol.rpcv2cbor.RpcV2CborErrorResponseMetadata;
import com.amazonaws.protocol.rpcv2cbor.RpcV2CborOperationMetadata;
import com.amazonaws.protocol.rpcv2cbor.SdkStructuredRpcV2CborFactory;
import com.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.util.List;
import java.util.Map;

public abstract class SdkStructuredRpcV2CborFactoryImpl
implements SdkStructuredRpcV2CborFactory {
    private final CBORFactory cborFactory;
    private final Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> unmarshallers;
    private final Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeUnmarshallers;

    public SdkStructuredRpcV2CborFactoryImpl(CBORFactory cborFactory, Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> unmarshallers, Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeUnmarshallers) {
        this.cborFactory = cborFactory;
        this.unmarshallers = unmarshallers;
        this.customTypeUnmarshallers = customTypeUnmarshallers;
    }

    @Override
    public StructuredRpcV2CborGenerator createWriter(String contentType) {
        return this.createWriter(this.cborFactory, contentType);
    }

    protected abstract StructuredRpcV2CborGenerator createWriter(CBORFactory var1, String var2);

    @Override
    public <T> RpcV2CborResponseHandler<T> createResponseHandler(RpcV2CborOperationMetadata operationMetadata, Unmarshaller<T, RpcV2CborUnmarshallerContext> responseUnmarshaller) {
        return new RpcV2CborResponseHandler<T>(responseUnmarshaller, this.unmarshallers, this.customTypeUnmarshallers, this.cborFactory, operationMetadata.isHasStreamingSuccessResponse(), operationMetadata.isPayloadRpcV2Cbor());
    }

    @Override
    public RpcV2CborErrorResponseHandler createErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, String customErrorCodeFieldName) {
        return new RpcV2CborErrorResponseHandler(errorUnmarshallers, this.unmarshallers, this.customTypeUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.cborFactory);
    }

    @Override
    public RpcV2CborErrorResponseHandler createErrorResponseHandler(RpcV2CborErrorResponseMetadata rpcv2cborErrorResponseMetadata, List<JsonErrorUnmarshaller> errorUnmarshallers) {
        boolean hasAwsQueryCompatible = rpcv2cborErrorResponseMetadata != null && rpcv2cborErrorResponseMetadata.getAwsQueryCompatible();
        String customErrorCodeFieldName = rpcv2cborErrorResponseMetadata != null ? rpcv2cborErrorResponseMetadata.getCustomErrorCodeFieldName() : null;
        return new RpcV2CborErrorResponseHandler(errorUnmarshallers, this.unmarshallers, this.customTypeUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), hasAwsQueryCompatible, JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.cborFactory);
    }

    protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new JsonErrorCodeParser(customErrorCodeFieldName);
    }
}

