/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.CurrentInstance;
import java.util.List;

@SdkInternalApi
public class CurrentInstanceMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceDetails").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEUTILIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceUtilization").build();
    private static final MarshallingInfo<String> RESERVATIONCOVEREDHOURSINLOOKBACKPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservationCoveredHoursInLookbackPeriod").build();
    private static final MarshallingInfo<String> SAVINGSPLANSCOVEREDHOURSINLOOKBACKPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SavingsPlansCoveredHoursInLookbackPeriod").build();
    private static final MarshallingInfo<String> ONDEMANDHOURSINLOOKBACKPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnDemandHoursInLookbackPeriod").build();
    private static final MarshallingInfo<String> TOTALRUNNINGHOURSINLOOKBACKPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalRunningHoursInLookbackPeriod").build();
    private static final MarshallingInfo<String> MONTHLYCOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MonthlyCost").build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrencyCode").build();
    private static final CurrentInstanceMarshaller instance = new CurrentInstanceMarshaller();

    public static CurrentInstanceMarshaller getInstance() {
        return instance;
    }

    public void marshall(CurrentInstance currentInstance, ProtocolMarshaller protocolMarshaller) {
        if (currentInstance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)currentInstance.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(currentInstance.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getResourceDetails(), RESOURCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getResourceUtilization(), RESOURCEUTILIZATION_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getReservationCoveredHoursInLookbackPeriod(), RESERVATIONCOVEREDHOURSINLOOKBACKPERIOD_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getSavingsPlansCoveredHoursInLookbackPeriod(), SAVINGSPLANSCOVEREDHOURSINLOOKBACKPERIOD_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getOnDemandHoursInLookbackPeriod(), ONDEMANDHOURSINLOOKBACKPERIOD_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getTotalRunningHoursInLookbackPeriod(), TOTALRUNNINGHOURSINLOOKBACKPERIOD_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getMonthlyCost(), MONTHLYCOST_BINDING);
            protocolMarshaller.marshall((Object)currentInstance.getCurrencyCode(), CURRENCYCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

