/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.costexplorer.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.costexplorer.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DiskResourceUtilization JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DiskResourceUtilizationJsonUnmarshaller implements Unmarshaller<DiskResourceUtilization, JsonUnmarshallerContext> {

    public DiskResourceUtilization unmarshall(JsonUnmarshallerContext context) throws Exception {
        DiskResourceUtilization diskResourceUtilization = new DiskResourceUtilization();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DiskReadOpsPerSecond", targetDepth)) {
                    context.nextToken();
                    diskResourceUtilization.setDiskReadOpsPerSecond(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DiskWriteOpsPerSecond", targetDepth)) {
                    context.nextToken();
                    diskResourceUtilization.setDiskWriteOpsPerSecond(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DiskReadBytesPerSecond", targetDepth)) {
                    context.nextToken();
                    diskResourceUtilization.setDiskReadBytesPerSecond(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DiskWriteBytesPerSecond", targetDepth)) {
                    context.nextToken();
                    diskResourceUtilization.setDiskWriteBytesPerSecond(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return diskResourceUtilization;
    }

    private static DiskResourceUtilizationJsonUnmarshaller instance;

    public static DiskResourceUtilizationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DiskResourceUtilizationJsonUnmarshaller();
        return instance;
    }
}
