/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.applicationdiscovery.model.NeighborConnectionDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServerNeighborsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<NeighborConnectionDetail> neighbors;
    private String nextToken;
    private Long knownDependencyCount;

    public List<NeighborConnectionDetail> getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(Collection<NeighborConnectionDetail> neighbors) {
        if (neighbors == null) {
            this.neighbors = null;
            return;
        }
        this.neighbors = new ArrayList<NeighborConnectionDetail>(neighbors);
    }

    public ListServerNeighborsResult withNeighbors(NeighborConnectionDetail ... neighbors) {
        if (this.neighbors == null) {
            this.setNeighbors(new ArrayList<NeighborConnectionDetail>(neighbors.length));
        }
        for (NeighborConnectionDetail ele : neighbors) {
            this.neighbors.add(ele);
        }
        return this;
    }

    public ListServerNeighborsResult withNeighbors(Collection<NeighborConnectionDetail> neighbors) {
        this.setNeighbors(neighbors);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServerNeighborsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setKnownDependencyCount(Long knownDependencyCount) {
        this.knownDependencyCount = knownDependencyCount;
    }

    public Long getKnownDependencyCount() {
        return this.knownDependencyCount;
    }

    public ListServerNeighborsResult withKnownDependencyCount(Long knownDependencyCount) {
        this.setKnownDependencyCount(knownDependencyCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNeighbors() != null) {
            sb.append("Neighbors: ").append(this.getNeighbors()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getKnownDependencyCount() != null) {
            sb.append("KnownDependencyCount: ").append(this.getKnownDependencyCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsResult)) {
            return false;
        }
        ListServerNeighborsResult other = (ListServerNeighborsResult)obj;
        if (other.getNeighbors() == null ^ this.getNeighbors() == null) {
            return false;
        }
        if (other.getNeighbors() != null && !other.getNeighbors().equals(this.getNeighbors())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getKnownDependencyCount() == null ^ this.getKnownDependencyCount() == null) {
            return false;
        }
        return other.getKnownDependencyCount() == null || other.getKnownDependencyCount().equals(this.getKnownDependencyCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNeighbors() == null ? 0 : this.getNeighbors().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getKnownDependencyCount() == null ? 0 : this.getKnownDependencyCount().hashCode());
        return hashCode;
    }

    public ListServerNeighborsResult clone() {
        try {
            return (ListServerNeighborsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

