/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.databasemigrationservice.model.Certificate;
import java.nio.ByteBuffer;
import java.util.Date;

@SdkInternalApi
public class CertificateMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateIdentifier").build();
    private static final MarshallingInfo<Date> CERTIFICATECREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateCreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificatePem").build();
    private static final MarshallingInfo<ByteBuffer> CERTIFICATEWALLET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateWallet").build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").build();
    private static final MarshallingInfo<String> CERTIFICATEOWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateOwner").build();
    private static final MarshallingInfo<Date> VALIDFROMDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidFromDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> VALIDTODATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidToDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SIGNINGALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningAlgorithm").build();
    private static final MarshallingInfo<Integer> KEYLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyLength").build();
    private static final CertificateMarshaller instance = new CertificateMarshaller();

    public static CertificateMarshaller getInstance() {
        return instance;
    }

    public void marshall(Certificate certificate, ProtocolMarshaller protocolMarshaller) {
        if (certificate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)certificate.getCertificateIdentifier(), CERTIFICATEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)certificate.getCertificateCreationDate(), CERTIFICATECREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)certificate.getCertificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)certificate.getCertificateWallet(), CERTIFICATEWALLET_BINDING);
            protocolMarshaller.marshall((Object)certificate.getCertificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)certificate.getCertificateOwner(), CERTIFICATEOWNER_BINDING);
            protocolMarshaller.marshall((Object)certificate.getValidFromDate(), VALIDFROMDATE_BINDING);
            protocolMarshaller.marshall((Object)certificate.getValidToDate(), VALIDTODATE_BINDING);
            protocolMarshaller.marshall((Object)certificate.getSigningAlgorithm(), SIGNINGALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)certificate.getKeyLength(), KEYLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

