/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceResult;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeIpamPoolsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * Information about the IPAM pools.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<IpamPool> ipamPools;

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *        more results to return.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *        more results to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamPoolsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * Information about the IPAM pools.
     * </p>
     * 
     * @return Information about the IPAM pools.
     */

    public java.util.List<IpamPool> getIpamPools() {
        if (ipamPools == null) {
            ipamPools = new com.amazonaws.internal.SdkInternalList<IpamPool>();
        }
        return ipamPools;
    }

    /**
     * <p>
     * Information about the IPAM pools.
     * </p>
     * 
     * @param ipamPools
     *        Information about the IPAM pools.
     */

    public void setIpamPools(java.util.Collection<IpamPool> ipamPools) {
        if (ipamPools == null) {
            this.ipamPools = null;
            return;
        }

        this.ipamPools = new com.amazonaws.internal.SdkInternalList<IpamPool>(ipamPools);
    }

    /**
     * <p>
     * Information about the IPAM pools.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIpamPools(java.util.Collection)} or {@link #withIpamPools(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param ipamPools
     *        Information about the IPAM pools.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamPoolsResult withIpamPools(IpamPool... ipamPools) {
        if (this.ipamPools == null) {
            setIpamPools(new com.amazonaws.internal.SdkInternalList<IpamPool>(ipamPools.length));
        }
        for (IpamPool ele : ipamPools) {
            this.ipamPools.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the IPAM pools.
     * </p>
     * 
     * @param ipamPools
     *        Information about the IPAM pools.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeIpamPoolsResult withIpamPools(java.util.Collection<IpamPool> ipamPools) {
        setIpamPools(ipamPools);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getIpamPools() != null)
            sb.append("IpamPools: ").append(getIpamPools());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeIpamPoolsResult == false)
            return false;
        DescribeIpamPoolsResult other = (DescribeIpamPoolsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getIpamPools() == null ^ this.getIpamPools() == null)
            return false;
        if (other.getIpamPools() != null && other.getIpamPools().equals(this.getIpamPools()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getIpamPools() == null) ? 0 : getIpamPools().hashCode());
        return hashCode;
    }

    @Override
    public DescribeIpamPoolsResult clone() {
        try {
            return (DescribeIpamPoolsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
