/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ecrpublic.AmazonECRPublic;
import com.amazonaws.services.ecrpublic.AmazonECRPublicClientBuilder;
import com.amazonaws.services.ecrpublic.model.AmazonECRPublicException;
import com.amazonaws.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecrpublic.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecrpublic.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecrpublic.model.BatchDeleteImageResult;
import com.amazonaws.services.ecrpublic.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecrpublic.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecrpublic.model.CreateRepositoryRequest;
import com.amazonaws.services.ecrpublic.model.CreateRepositoryResult;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryResult;
import com.amazonaws.services.ecrpublic.model.DescribeImageTagsRequest;
import com.amazonaws.services.ecrpublic.model.DescribeImageTagsResult;
import com.amazonaws.services.ecrpublic.model.DescribeImagesRequest;
import com.amazonaws.services.ecrpublic.model.DescribeImagesResult;
import com.amazonaws.services.ecrpublic.model.DescribeRegistriesRequest;
import com.amazonaws.services.ecrpublic.model.DescribeRegistriesResult;
import com.amazonaws.services.ecrpublic.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecrpublic.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecrpublic.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecrpublic.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.GetRegistryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.GetRepositoryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecrpublic.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecrpublic.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecrpublic.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecrpublic.model.PutImageRequest;
import com.amazonaws.services.ecrpublic.model.PutImageResult;
import com.amazonaws.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.PutRegistryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.PutRepositoryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecrpublic.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecrpublic.model.UploadLayerPartRequest;
import com.amazonaws.services.ecrpublic.model.UploadLayerPartResult;
import com.amazonaws.services.ecrpublic.model.transform.BatchCheckLayerAvailabilityRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.BatchCheckLayerAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.BatchDeleteImageRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.BatchDeleteImageResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.CompleteLayerUploadRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.CompleteLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.CreateRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.CreateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DeleteRepositoryPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DeleteRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DeleteRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DeleteRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeImageTagsRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeImageTagsResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeImagesRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeImagesResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeRegistriesRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeRegistriesResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeRepositoriesRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.DescribeRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.EmptyUploadExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetAuthorizationTokenRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetAuthorizationTokenResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetRegistryCatalogDataRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetRegistryCatalogDataResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetRepositoryCatalogDataRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetRepositoryCatalogDataResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetRepositoryPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.GetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.ImageAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.ImageDigestDoesNotMatchExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.ImageNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.ImageTagAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.InitiateLayerUploadRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.InitiateLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.InvalidLayerExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.InvalidLayerPartExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.LayerAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.LayerPartTooSmallExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.LayersNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.PutImageRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.PutImageResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.PutRegistryCatalogDataRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.PutRegistryCatalogDataResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.PutRepositoryCatalogDataRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.PutRepositoryCatalogDataResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.ReferencedImagesNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.RegistryNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.RepositoryAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.RepositoryNotEmptyExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.RepositoryNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.RepositoryPolicyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.ServerExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.SetRepositoryPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.SetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.UnsupportedCommandExceptionUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.UploadLayerPartRequestProtocolMarshaller;
import com.amazonaws.services.ecrpublic.model.transform.UploadLayerPartResultJsonUnmarshaller;
import com.amazonaws.services.ecrpublic.model.transform.UploadNotFoundExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonECRPublicClient
extends AmazonWebServiceClient
implements AmazonECRPublic {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECRPublic.class);
    private static final String DEFAULT_SIGNING_NAME = "ecr-public";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedCommandException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedCommandExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerPartTooSmallException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LayerPartTooSmallExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerPartException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidLayerPartExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageTagAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ImageTagAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotEmptyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RepositoryNotEmptyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LayerAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageDigestDoesNotMatchException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ImageDigestDoesNotMatchExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RegistryNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RegistryNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EmptyUploadException").withExceptionUnmarshaller((JsonErrorUnmarshaller)EmptyUploadExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ImageNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayersNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LayersNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReferencedImagesNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ReferencedImagesNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidLayerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RepositoryNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RepositoryAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryPolicyNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RepositoryPolicyNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ImageAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UploadNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UploadNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonECRPublicException.class));

    public static AmazonECRPublicClientBuilder builder() {
        return AmazonECRPublicClientBuilder.standard();
    }

    AmazonECRPublicClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonECRPublicClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("api.ecr-public");
        this.setEndpoint("api.ecr-public.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecrpublic/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecrpublic/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCheckLayerAvailabilityResult batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest request) {
        request = (BatchCheckLayerAvailabilityRequest)this.beforeClientExecution(request);
        return this.executeBatchCheckLayerAvailability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCheckLayerAvailabilityResult executeBatchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCheckLayerAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCheckLayerAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCheckLayerAvailabilityRequestProtocolMarshaller(protocolFactory).marshall((BatchCheckLayerAvailabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCheckLayerAvailabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchCheckLayerAvailability");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchCheckLayerAvailabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCheckLayerAvailabilityResult batchCheckLayerAvailabilityResult = (BatchCheckLayerAvailabilityResult)response.getAwsResponse();
            return batchCheckLayerAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDeleteImageResult batchDeleteImage(BatchDeleteImageRequest request) {
        request = (BatchDeleteImageRequest)this.beforeClientExecution(request);
        return this.executeBatchDeleteImage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteImageResult executeBatchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteImageRequestProtocolMarshaller(protocolFactory).marshall((BatchDeleteImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDeleteImage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteImageResult batchDeleteImageResult = (BatchDeleteImageResult)response.getAwsResponse();
            return batchDeleteImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CompleteLayerUploadResult completeLayerUpload(CompleteLayerUploadRequest request) {
        request = (CompleteLayerUploadRequest)this.beforeClientExecution(request);
        return this.executeCompleteLayerUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CompleteLayerUploadResult executeCompleteLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteLayerUploadRequestProtocolMarshaller(protocolFactory).marshall((CompleteLayerUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CompleteLayerUpload");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteLayerUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CompleteLayerUploadResult completeLayerUploadResult = (CompleteLayerUploadResult)response.getAwsResponse();
            return completeLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest request) {
        request = (CreateRepositoryRequest)this.beforeClientExecution(request);
        return this.executeCreateRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRepositoryResult executeCreateRepository(CreateRepositoryRequest createRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRepositoryRequestProtocolMarshaller(protocolFactory).marshall((CreateRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRepository");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRepositoryResult createRepositoryResult = (CreateRepositoryResult)response.getAwsResponse();
            return createRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest request) {
        request = (DeleteRepositoryRequest)this.beforeClientExecution(request);
        return this.executeDeleteRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRepositoryResult executeDeleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryRequestProtocolMarshaller(protocolFactory).marshall((DeleteRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRepository");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryResult deleteRepositoryResult = (DeleteRepositoryResult)response.getAwsResponse();
            return deleteRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRepositoryPolicyResult deleteRepositoryPolicy(DeleteRepositoryPolicyRequest request) {
        request = (DeleteRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteRepositoryPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRepositoryPolicyResult executeDeleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRepositoryPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryPolicyResult deleteRepositoryPolicyResult = (DeleteRepositoryPolicyResult)response.getAwsResponse();
            return deleteRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeImageTagsResult describeImageTags(DescribeImageTagsRequest request) {
        request = (DescribeImageTagsRequest)this.beforeClientExecution(request);
        return this.executeDescribeImageTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeImageTagsResult executeDescribeImageTags(DescribeImageTagsRequest describeImageTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeImageTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeImageTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeImageTagsRequestProtocolMarshaller(protocolFactory).marshall((DescribeImageTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeImageTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeImageTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeImageTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeImageTagsResult describeImageTagsResult = (DescribeImageTagsResult)response.getAwsResponse();
            return describeImageTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeImagesResult describeImages(DescribeImagesRequest request) {
        request = (DescribeImagesRequest)this.beforeClientExecution(request);
        return this.executeDescribeImages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeImagesResult executeDescribeImages(DescribeImagesRequest describeImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeImagesRequestProtocolMarshaller(protocolFactory).marshall((DescribeImagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeImages");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeImagesResult describeImagesResult = (DescribeImagesResult)response.getAwsResponse();
            return describeImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRegistriesResult describeRegistries(DescribeRegistriesRequest request) {
        request = (DescribeRegistriesRequest)this.beforeClientExecution(request);
        return this.executeDescribeRegistries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRegistriesResult executeDescribeRegistries(DescribeRegistriesRequest describeRegistriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRegistriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRegistriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRegistriesRequestProtocolMarshaller(protocolFactory).marshall((DescribeRegistriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRegistriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRegistries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRegistriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRegistriesResult describeRegistriesResult = (DescribeRegistriesResult)response.getAwsResponse();
            return describeRegistriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRepositoriesResult describeRepositories(DescribeRepositoriesRequest request) {
        request = (DescribeRepositoriesRequest)this.beforeClientExecution(request);
        return this.executeDescribeRepositories(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRepositoriesResult executeDescribeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRepositoriesRequestProtocolMarshaller(protocolFactory).marshall((DescribeRepositoriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRepositories");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRepositoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRepositoriesResult describeRepositoriesResult = (DescribeRepositoriesResult)response.getAwsResponse();
            return describeRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAuthorizationTokenResult getAuthorizationToken(GetAuthorizationTokenRequest request) {
        request = (GetAuthorizationTokenRequest)this.beforeClientExecution(request);
        return this.executeGetAuthorizationToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAuthorizationTokenResult executeGetAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAuthorizationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAuthorizationTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAuthorizationTokenRequestProtocolMarshaller(protocolFactory).marshall((GetAuthorizationTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAuthorizationTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAuthorizationToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAuthorizationTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAuthorizationTokenResult getAuthorizationTokenResult = (GetAuthorizationTokenResult)response.getAwsResponse();
            return getAuthorizationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRegistryCatalogDataResult getRegistryCatalogData(GetRegistryCatalogDataRequest request) {
        request = (GetRegistryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executeGetRegistryCatalogData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRegistryCatalogDataResult executeGetRegistryCatalogData(GetRegistryCatalogDataRequest getRegistryCatalogDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRegistryCatalogDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRegistryCatalogDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRegistryCatalogDataRequestProtocolMarshaller(protocolFactory).marshall((GetRegistryCatalogDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRegistryCatalogDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRegistryCatalogData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRegistryCatalogDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRegistryCatalogDataResult getRegistryCatalogDataResult = (GetRegistryCatalogDataResult)response.getAwsResponse();
            return getRegistryCatalogDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRepositoryCatalogDataResult getRepositoryCatalogData(GetRepositoryCatalogDataRequest request) {
        request = (GetRepositoryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executeGetRepositoryCatalogData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRepositoryCatalogDataResult executeGetRepositoryCatalogData(GetRepositoryCatalogDataRequest getRepositoryCatalogDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryCatalogDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryCatalogDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryCatalogDataRequestProtocolMarshaller(protocolFactory).marshall((GetRepositoryCatalogDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRepositoryCatalogDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRepositoryCatalogData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRepositoryCatalogDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryCatalogDataResult getRepositoryCatalogDataResult = (GetRepositoryCatalogDataResult)response.getAwsResponse();
            return getRepositoryCatalogDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRepositoryPolicyResult getRepositoryPolicy(GetRepositoryPolicyRequest request) {
        request = (GetRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetRepositoryPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRepositoryPolicyResult executeGetRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRepositoryPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryPolicyResult getRepositoryPolicyResult = (GetRepositoryPolicyResult)response.getAwsResponse();
            return getRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InitiateLayerUploadResult initiateLayerUpload(InitiateLayerUploadRequest request) {
        request = (InitiateLayerUploadRequest)this.beforeClientExecution(request);
        return this.executeInitiateLayerUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InitiateLayerUploadResult executeInitiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateLayerUploadRequestProtocolMarshaller(protocolFactory).marshall((InitiateLayerUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InitiateLayerUpload");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateLayerUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateLayerUploadResult initiateLayerUploadResult = (InitiateLayerUploadResult)response.getAwsResponse();
            return initiateLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutImageResult putImage(PutImageRequest request) {
        request = (PutImageRequest)this.beforeClientExecution(request);
        return this.executePutImage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutImageResult executePutImage(PutImageRequest putImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutImageRequestProtocolMarshaller(protocolFactory).marshall((PutImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)putImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutImage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutImageResult putImageResult = (PutImageResult)response.getAwsResponse();
            return putImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRegistryCatalogDataResult putRegistryCatalogData(PutRegistryCatalogDataRequest request) {
        request = (PutRegistryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executePutRegistryCatalogData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRegistryCatalogDataResult executePutRegistryCatalogData(PutRegistryCatalogDataRequest putRegistryCatalogDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRegistryCatalogDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRegistryCatalogDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRegistryCatalogDataRequestProtocolMarshaller(protocolFactory).marshall((PutRegistryCatalogDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRegistryCatalogDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRegistryCatalogData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRegistryCatalogDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRegistryCatalogDataResult putRegistryCatalogDataResult = (PutRegistryCatalogDataResult)response.getAwsResponse();
            return putRegistryCatalogDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRepositoryCatalogDataResult putRepositoryCatalogData(PutRepositoryCatalogDataRequest request) {
        request = (PutRepositoryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executePutRepositoryCatalogData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRepositoryCatalogDataResult executePutRepositoryCatalogData(PutRepositoryCatalogDataRequest putRepositoryCatalogDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRepositoryCatalogDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRepositoryCatalogDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRepositoryCatalogDataRequestProtocolMarshaller(protocolFactory).marshall((PutRepositoryCatalogDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRepositoryCatalogDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRepositoryCatalogData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRepositoryCatalogDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRepositoryCatalogDataResult putRepositoryCatalogDataResult = (PutRepositoryCatalogDataResult)response.getAwsResponse();
            return putRepositoryCatalogDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SetRepositoryPolicyResult setRepositoryPolicy(SetRepositoryPolicyRequest request) {
        request = (SetRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executeSetRepositoryPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SetRepositoryPolicyResult executeSetRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetRepositoryPolicyRequestProtocolMarshaller(protocolFactory).marshall((SetRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)setRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SetRepositoryPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetRepositoryPolicyResult setRepositoryPolicyResult = (SetRepositoryPolicyResult)response.getAwsResponse();
            return setRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UploadLayerPartResult uploadLayerPart(UploadLayerPartRequest request) {
        request = (UploadLayerPartRequest)this.beforeClientExecution(request);
        return this.executeUploadLayerPart(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UploadLayerPartResult executeUploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadLayerPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadLayerPartRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadLayerPartRequestProtocolMarshaller(protocolFactory).marshall((UploadLayerPartRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadLayerPartRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECR PUBLIC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UploadLayerPart");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadLayerPartResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UploadLayerPartResult uploadLayerPartResult = (UploadLayerPartResult)response.getAwsResponse();
            return uploadLayerPartResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

