/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.finspacedata.model.ApplicationPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePermissionGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<String> applicationPermissions;
    private String clientToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreatePermissionGroupRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePermissionGroupRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getApplicationPermissions() {
        return this.applicationPermissions;
    }

    public void setApplicationPermissions(Collection<String> applicationPermissions) {
        if (applicationPermissions == null) {
            this.applicationPermissions = null;
            return;
        }
        this.applicationPermissions = new ArrayList<String>(applicationPermissions);
    }

    public CreatePermissionGroupRequest withApplicationPermissions(String ... applicationPermissions) {
        if (this.applicationPermissions == null) {
            this.setApplicationPermissions(new ArrayList<String>(applicationPermissions.length));
        }
        for (String ele : applicationPermissions) {
            this.applicationPermissions.add(ele);
        }
        return this;
    }

    public CreatePermissionGroupRequest withApplicationPermissions(Collection<String> applicationPermissions) {
        this.setApplicationPermissions(applicationPermissions);
        return this;
    }

    public CreatePermissionGroupRequest withApplicationPermissions(ApplicationPermission ... applicationPermissions) {
        ArrayList<String> applicationPermissionsCopy = new ArrayList<String>(applicationPermissions.length);
        for (ApplicationPermission value : applicationPermissions) {
            applicationPermissionsCopy.add(value.toString());
        }
        if (this.getApplicationPermissions() == null) {
            this.setApplicationPermissions(applicationPermissionsCopy);
        } else {
            this.getApplicationPermissions().addAll(applicationPermissionsCopy);
        }
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreatePermissionGroupRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getApplicationPermissions() != null) {
            sb.append("ApplicationPermissions: ").append(this.getApplicationPermissions()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePermissionGroupRequest)) {
            return false;
        }
        CreatePermissionGroupRequest other = (CreatePermissionGroupRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getApplicationPermissions() == null ^ this.getApplicationPermissions() == null) {
            return false;
        }
        if (other.getApplicationPermissions() != null && !other.getApplicationPermissions().equals(this.getApplicationPermissions())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationPermissions() == null ? 0 : this.getApplicationPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreatePermissionGroupRequest clone() {
        return (CreatePermissionGroupRequest)super.clone();
    }
}

