/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glue.model.Partition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetPartitionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Partition> partitions;
    private String nextToken;

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Collection<Partition> partitions) {
        if (partitions == null) {
            this.partitions = null;
            return;
        }
        this.partitions = new ArrayList<Partition>(partitions);
    }

    public GetPartitionsResult withPartitions(Partition ... partitions) {
        if (this.partitions == null) {
            this.setPartitions(new ArrayList<Partition>(partitions.length));
        }
        for (Partition ele : partitions) {
            this.partitions.add(ele);
        }
        return this;
    }

    public GetPartitionsResult withPartitions(Collection<Partition> partitions) {
        this.setPartitions(partitions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetPartitionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPartitions() != null) {
            sb.append("Partitions: ").append(this.getPartitions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionsResult)) {
            return false;
        }
        GetPartitionsResult other = (GetPartitionsResult)obj;
        if (other.getPartitions() == null ^ this.getPartitions() == null) {
            return false;
        }
        if (other.getPartitions() != null && !other.getPartitions().equals(this.getPartitions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPartitions() == null ? 0 : this.getPartitions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetPartitionsResult clone() {
        try {
            return (GetPartitionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

