/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.DynamoDBTargetMarshaller;
import java.io.Serializable;

public class DynamoDBTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private Boolean scanAll;
    private Double scanRate;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public DynamoDBTarget withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setScanAll(Boolean scanAll) {
        this.scanAll = scanAll;
    }

    public Boolean getScanAll() {
        return this.scanAll;
    }

    public DynamoDBTarget withScanAll(Boolean scanAll) {
        this.setScanAll(scanAll);
        return this;
    }

    public Boolean isScanAll() {
        return this.scanAll;
    }

    public void setScanRate(Double scanRate) {
        this.scanRate = scanRate;
    }

    public Double getScanRate() {
        return this.scanRate;
    }

    public DynamoDBTarget withScanRate(Double scanRate) {
        this.setScanRate(scanRate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getScanAll() != null) {
            sb.append("ScanAll: ").append(this.getScanAll()).append(",");
        }
        if (this.getScanRate() != null) {
            sb.append("ScanRate: ").append(this.getScanRate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBTarget)) {
            return false;
        }
        DynamoDBTarget other = (DynamoDBTarget)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getScanAll() == null ^ this.getScanAll() == null) {
            return false;
        }
        if (other.getScanAll() != null && !other.getScanAll().equals(this.getScanAll())) {
            return false;
        }
        if (other.getScanRate() == null ^ this.getScanRate() == null) {
            return false;
        }
        return other.getScanRate() == null || other.getScanRate().equals(this.getScanRate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getScanAll() == null ? 0 : this.getScanAll().hashCode());
        hashCode = 31 * hashCode + (this.getScanRate() == null ? 0 : this.getScanRate().hashCode());
        return hashCode;
    }

    public DynamoDBTarget clone() {
        try {
            return (DynamoDBTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

