/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.S3Target;
import java.util.List;

@SdkInternalApi
public class S3TargetMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<List> EXCLUSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Exclusions").build();
    private static final MarshallingInfo<String> CONNECTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionName").build();
    private static final MarshallingInfo<Integer> SAMPLESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleSize").build();
    private static final MarshallingInfo<String> EVENTQUEUEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventQueueArn").build();
    private static final MarshallingInfo<String> DLQEVENTQUEUEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DlqEventQueueArn").build();
    private static final S3TargetMarshaller instance = new S3TargetMarshaller();

    public static S3TargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Target s3Target, ProtocolMarshaller protocolMarshaller) {
        if (s3Target == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Target.getPath(), PATH_BINDING);
            protocolMarshaller.marshall(s3Target.getExclusions(), EXCLUSIONS_BINDING);
            protocolMarshaller.marshall((Object)s3Target.getConnectionName(), CONNECTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Target.getSampleSize(), SAMPLESIZE_BINDING);
            protocolMarshaller.marshall((Object)s3Target.getEventQueueArn(), EVENTQUEUEARN_BINDING);
            protocolMarshaller.marshall((Object)s3Target.getDlqEventQueueArn(), DLQEVENTQUEUEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

