/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Specifies a column to be joined.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JoinColumn" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class JoinColumn implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The column to be joined.
     * </p>
     */
    private String from;
    /**
     * <p>
     * The key of the column to be joined.
     * </p>
     */
    private java.util.List<java.util.List<String>> keys;

    /**
     * <p>
     * The column to be joined.
     * </p>
     * 
     * @param from
     *        The column to be joined.
     */

    public void setFrom(String from) {
        this.from = from;
    }

    /**
     * <p>
     * The column to be joined.
     * </p>
     * 
     * @return The column to be joined.
     */

    public String getFrom() {
        return this.from;
    }

    /**
     * <p>
     * The column to be joined.
     * </p>
     * 
     * @param from
     *        The column to be joined.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JoinColumn withFrom(String from) {
        setFrom(from);
        return this;
    }

    /**
     * <p>
     * The key of the column to be joined.
     * </p>
     * 
     * @return The key of the column to be joined.
     */

    public java.util.List<java.util.List<String>> getKeys() {
        return keys;
    }

    /**
     * <p>
     * The key of the column to be joined.
     * </p>
     * 
     * @param keys
     *        The key of the column to be joined.
     */

    public void setKeys(java.util.Collection<java.util.List<String>> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }

        this.keys = new java.util.ArrayList<java.util.List<String>>(keys);
    }

    /**
     * <p>
     * The key of the column to be joined.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setKeys(java.util.Collection)} or {@link #withKeys(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param keys
     *        The key of the column to be joined.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JoinColumn withKeys(java.util.List<String>... keys) {
        if (this.keys == null) {
            setKeys(new java.util.ArrayList<java.util.List<String>>(keys.length));
        }
        for (java.util.List<String> ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The key of the column to be joined.
     * </p>
     * 
     * @param keys
     *        The key of the column to be joined.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JoinColumn withKeys(java.util.Collection<java.util.List<String>> keys) {
        setKeys(keys);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFrom() != null)
            sb.append("From: ").append(getFrom()).append(",");
        if (getKeys() != null)
            sb.append("Keys: ").append(getKeys());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof JoinColumn == false)
            return false;
        JoinColumn other = (JoinColumn) obj;
        if (other.getFrom() == null ^ this.getFrom() == null)
            return false;
        if (other.getFrom() != null && other.getFrom().equals(this.getFrom()) == false)
            return false;
        if (other.getKeys() == null ^ this.getKeys() == null)
            return false;
        if (other.getKeys() != null && other.getKeys().equals(this.getKeys()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFrom() == null) ? 0 : getFrom().hashCode());
        hashCode = prime * hashCode + ((getKeys() == null) ? 0 : getKeys().hashCode());
        return hashCode;
    }

    @Override
    public JoinColumn clone() {
        try {
            return (JoinColumn) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.glue.model.transform.JoinColumnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
