/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.services.gluedatabrew.model.ExcelOptions;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ExcelOptionsJsonUnmarshaller
implements Unmarshaller<ExcelOptions, JsonUnmarshallerContext> {
    private static ExcelOptionsJsonUnmarshaller instance;

    public ExcelOptions unmarshall(JsonUnmarshallerContext context) throws Exception {
        ExcelOptions excelOptions = new ExcelOptions();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SheetNames", targetDepth)) {
                    context.nextToken();
                    excelOptions.setSheetNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SheetIndexes", targetDepth)) {
                    context.nextToken();
                    excelOptions.setSheetIndexes(new ListUnmarshaller(context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return excelOptions;
    }

    public static ExcelOptionsJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExcelOptionsJsonUnmarshaller();
        }
        return instance;
    }
}

