/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/S3TableOutputOptions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class S3TableOutputOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     * </p>
     */
    private S3Location location;

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     * </p>
     * 
     * @param location
     *        Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     */

    public void setLocation(S3Location location) {
        this.location = location;
    }

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     * </p>
     * 
     * @return Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     */

    public S3Location getLocation() {
        return this.location;
    }

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     * </p>
     * 
     * @param location
     *        Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public S3TableOutputOptions withLocation(S3Location location) {
        setLocation(location);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLocation() != null)
            sb.append("Location: ").append(getLocation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof S3TableOutputOptions == false)
            return false;
        S3TableOutputOptions other = (S3TableOutputOptions) obj;
        if (other.getLocation() == null ^ this.getLocation() == null)
            return false;
        if (other.getLocation() != null && other.getLocation().equals(this.getLocation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLocation() == null) ? 0 : getLocation().hashCode());
        return hashCode;
    }

    @Override
    public S3TableOutputOptions clone() {
        try {
            return (S3TableOutputOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.gluedatabrew.model.transform.S3TableOutputOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
