/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.S3Object;
import com.amazonaws.services.groundstation.model.TLEData;
import com.amazonaws.services.groundstation.model.transform.TLEEphemerisMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TLEEphemeris
implements Serializable,
Cloneable,
StructuredPojo {
    private S3Object s3Object;
    private List<TLEData> tleData;

    public void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    public S3Object getS3Object() {
        return this.s3Object;
    }

    public TLEEphemeris withS3Object(S3Object s3Object) {
        this.setS3Object(s3Object);
        return this;
    }

    public List<TLEData> getTleData() {
        return this.tleData;
    }

    public void setTleData(Collection<TLEData> tleData) {
        if (tleData == null) {
            this.tleData = null;
            return;
        }
        this.tleData = new ArrayList<TLEData>(tleData);
    }

    public TLEEphemeris withTleData(TLEData ... tleData) {
        if (this.tleData == null) {
            this.setTleData(new ArrayList<TLEData>(tleData.length));
        }
        for (TLEData ele : tleData) {
            this.tleData.add(ele);
        }
        return this;
    }

    public TLEEphemeris withTleData(Collection<TLEData> tleData) {
        this.setTleData(tleData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Object() != null) {
            sb.append("S3Object: ").append(this.getS3Object()).append(",");
        }
        if (this.getTleData() != null) {
            sb.append("TleData: ").append(this.getTleData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLEEphemeris)) {
            return false;
        }
        TLEEphemeris other = (TLEEphemeris)obj;
        if (other.getS3Object() == null ^ this.getS3Object() == null) {
            return false;
        }
        if (other.getS3Object() != null && !other.getS3Object().equals(this.getS3Object())) {
            return false;
        }
        if (other.getTleData() == null ^ this.getTleData() == null) {
            return false;
        }
        return other.getTleData() == null || other.getTleData().equals(this.getTleData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Object() == null ? 0 : this.getS3Object().hashCode());
        hashCode = 31 * hashCode + (this.getTleData() == null ? 0 : this.getTleData().hashCode());
        return hashCode;
    }

    public TLEEphemeris clone() {
        try {
            return (TLEEphemeris)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TLEEphemerisMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

