/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMalwareProtectionPlan"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteMalwareProtectionPlanRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan resource.
     * </p>
     */
    private String malwareProtectionPlanId;

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan resource.
     * </p>
     * 
     * @param malwareProtectionPlanId
     *        A unique identifier associated with Malware Protection plan resource.
     */

    public void setMalwareProtectionPlanId(String malwareProtectionPlanId) {
        this.malwareProtectionPlanId = malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan resource.
     * </p>
     * 
     * @return A unique identifier associated with Malware Protection plan resource.
     */

    public String getMalwareProtectionPlanId() {
        return this.malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with Malware Protection plan resource.
     * </p>
     * 
     * @param malwareProtectionPlanId
     *        A unique identifier associated with Malware Protection plan resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteMalwareProtectionPlanRequest withMalwareProtectionPlanId(String malwareProtectionPlanId) {
        setMalwareProtectionPlanId(malwareProtectionPlanId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMalwareProtectionPlanId() != null)
            sb.append("MalwareProtectionPlanId: ").append(getMalwareProtectionPlanId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteMalwareProtectionPlanRequest == false)
            return false;
        DeleteMalwareProtectionPlanRequest other = (DeleteMalwareProtectionPlanRequest) obj;
        if (other.getMalwareProtectionPlanId() == null ^ this.getMalwareProtectionPlanId() == null)
            return false;
        if (other.getMalwareProtectionPlanId() != null && other.getMalwareProtectionPlanId().equals(this.getMalwareProtectionPlanId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMalwareProtectionPlanId() == null) ? 0 : getMalwareProtectionPlanId().hashCode());
        return hashCode;
    }

    @Override
    public DeleteMalwareProtectionPlanRequest clone() {
        return (DeleteMalwareProtectionPlanRequest) super.clone();
    }

}
