/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.health.AWSHealthAsync;
import com.amazonaws.services.health.AWSHealthAsyncClientBuilder;
import com.amazonaws.services.health.AWSHealthClient;
import com.amazonaws.services.health.model.DescribeAffectedAccountsForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeAffectedAccountsForOrganizationResult;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesForOrganizationResult;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesRequest;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesResult;
import com.amazonaws.services.health.model.DescribeEntityAggregatesForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeEntityAggregatesForOrganizationResult;
import com.amazonaws.services.health.model.DescribeEntityAggregatesRequest;
import com.amazonaws.services.health.model.DescribeEntityAggregatesResult;
import com.amazonaws.services.health.model.DescribeEventAggregatesRequest;
import com.amazonaws.services.health.model.DescribeEventAggregatesResult;
import com.amazonaws.services.health.model.DescribeEventDetailsForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeEventDetailsForOrganizationResult;
import com.amazonaws.services.health.model.DescribeEventDetailsRequest;
import com.amazonaws.services.health.model.DescribeEventDetailsResult;
import com.amazonaws.services.health.model.DescribeEventTypesRequest;
import com.amazonaws.services.health.model.DescribeEventTypesResult;
import com.amazonaws.services.health.model.DescribeEventsForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeEventsForOrganizationResult;
import com.amazonaws.services.health.model.DescribeEventsRequest;
import com.amazonaws.services.health.model.DescribeEventsResult;
import com.amazonaws.services.health.model.DescribeHealthServiceStatusForOrganizationRequest;
import com.amazonaws.services.health.model.DescribeHealthServiceStatusForOrganizationResult;
import com.amazonaws.services.health.model.DisableHealthServiceAccessForOrganizationRequest;
import com.amazonaws.services.health.model.DisableHealthServiceAccessForOrganizationResult;
import com.amazonaws.services.health.model.EnableHealthServiceAccessForOrganizationRequest;
import com.amazonaws.services.health.model.EnableHealthServiceAccessForOrganizationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSHealthAsyncClient
extends AWSHealthClient
implements AWSHealthAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSHealthAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSHealthAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSHealthAsyncClientBuilder asyncBuilder() {
        return AWSHealthAsyncClientBuilder.standard();
    }

    AWSHealthAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSHealthAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeAffectedAccountsForOrganizationResult> describeAffectedAccountsForOrganizationAsync(DescribeAffectedAccountsForOrganizationRequest request) {
        return this.describeAffectedAccountsForOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeAffectedAccountsForOrganizationResult> describeAffectedAccountsForOrganizationAsync(DescribeAffectedAccountsForOrganizationRequest request, final AsyncHandler<DescribeAffectedAccountsForOrganizationRequest, DescribeAffectedAccountsForOrganizationResult> asyncHandler) {
        final DescribeAffectedAccountsForOrganizationRequest finalRequest = (DescribeAffectedAccountsForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAffectedAccountsForOrganizationResult>(){

            @Override
            public DescribeAffectedAccountsForOrganizationResult call() throws Exception {
                DescribeAffectedAccountsForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeAffectedAccountsForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAffectedEntitiesResult> describeAffectedEntitiesAsync(DescribeAffectedEntitiesRequest request) {
        return this.describeAffectedEntitiesAsync(request, null);
    }

    @Override
    public Future<DescribeAffectedEntitiesResult> describeAffectedEntitiesAsync(DescribeAffectedEntitiesRequest request, final AsyncHandler<DescribeAffectedEntitiesRequest, DescribeAffectedEntitiesResult> asyncHandler) {
        final DescribeAffectedEntitiesRequest finalRequest = (DescribeAffectedEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAffectedEntitiesResult>(){

            @Override
            public DescribeAffectedEntitiesResult call() throws Exception {
                DescribeAffectedEntitiesResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeAffectedEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAffectedEntitiesForOrganizationResult> describeAffectedEntitiesForOrganizationAsync(DescribeAffectedEntitiesForOrganizationRequest request) {
        return this.describeAffectedEntitiesForOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeAffectedEntitiesForOrganizationResult> describeAffectedEntitiesForOrganizationAsync(DescribeAffectedEntitiesForOrganizationRequest request, final AsyncHandler<DescribeAffectedEntitiesForOrganizationRequest, DescribeAffectedEntitiesForOrganizationResult> asyncHandler) {
        final DescribeAffectedEntitiesForOrganizationRequest finalRequest = (DescribeAffectedEntitiesForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAffectedEntitiesForOrganizationResult>(){

            @Override
            public DescribeAffectedEntitiesForOrganizationResult call() throws Exception {
                DescribeAffectedEntitiesForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeAffectedEntitiesForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEntityAggregatesResult> describeEntityAggregatesAsync(DescribeEntityAggregatesRequest request) {
        return this.describeEntityAggregatesAsync(request, null);
    }

    @Override
    public Future<DescribeEntityAggregatesResult> describeEntityAggregatesAsync(DescribeEntityAggregatesRequest request, final AsyncHandler<DescribeEntityAggregatesRequest, DescribeEntityAggregatesResult> asyncHandler) {
        final DescribeEntityAggregatesRequest finalRequest = (DescribeEntityAggregatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEntityAggregatesResult>(){

            @Override
            public DescribeEntityAggregatesResult call() throws Exception {
                DescribeEntityAggregatesResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEntityAggregates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEntityAggregatesForOrganizationResult> describeEntityAggregatesForOrganizationAsync(DescribeEntityAggregatesForOrganizationRequest request) {
        return this.describeEntityAggregatesForOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeEntityAggregatesForOrganizationResult> describeEntityAggregatesForOrganizationAsync(DescribeEntityAggregatesForOrganizationRequest request, final AsyncHandler<DescribeEntityAggregatesForOrganizationRequest, DescribeEntityAggregatesForOrganizationResult> asyncHandler) {
        final DescribeEntityAggregatesForOrganizationRequest finalRequest = (DescribeEntityAggregatesForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEntityAggregatesForOrganizationResult>(){

            @Override
            public DescribeEntityAggregatesForOrganizationResult call() throws Exception {
                DescribeEntityAggregatesForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEntityAggregatesForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventAggregatesResult> describeEventAggregatesAsync(DescribeEventAggregatesRequest request) {
        return this.describeEventAggregatesAsync(request, null);
    }

    @Override
    public Future<DescribeEventAggregatesResult> describeEventAggregatesAsync(DescribeEventAggregatesRequest request, final AsyncHandler<DescribeEventAggregatesRequest, DescribeEventAggregatesResult> asyncHandler) {
        final DescribeEventAggregatesRequest finalRequest = (DescribeEventAggregatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventAggregatesResult>(){

            @Override
            public DescribeEventAggregatesResult call() throws Exception {
                DescribeEventAggregatesResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEventAggregates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventDetailsResult> describeEventDetailsAsync(DescribeEventDetailsRequest request) {
        return this.describeEventDetailsAsync(request, null);
    }

    @Override
    public Future<DescribeEventDetailsResult> describeEventDetailsAsync(DescribeEventDetailsRequest request, final AsyncHandler<DescribeEventDetailsRequest, DescribeEventDetailsResult> asyncHandler) {
        final DescribeEventDetailsRequest finalRequest = (DescribeEventDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventDetailsResult>(){

            @Override
            public DescribeEventDetailsResult call() throws Exception {
                DescribeEventDetailsResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEventDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventDetailsForOrganizationResult> describeEventDetailsForOrganizationAsync(DescribeEventDetailsForOrganizationRequest request) {
        return this.describeEventDetailsForOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeEventDetailsForOrganizationResult> describeEventDetailsForOrganizationAsync(DescribeEventDetailsForOrganizationRequest request, final AsyncHandler<DescribeEventDetailsForOrganizationRequest, DescribeEventDetailsForOrganizationResult> asyncHandler) {
        final DescribeEventDetailsForOrganizationRequest finalRequest = (DescribeEventDetailsForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventDetailsForOrganizationResult>(){

            @Override
            public DescribeEventDetailsForOrganizationResult call() throws Exception {
                DescribeEventDetailsForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEventDetailsForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventTypesResult> describeEventTypesAsync(DescribeEventTypesRequest request) {
        return this.describeEventTypesAsync(request, null);
    }

    @Override
    public Future<DescribeEventTypesResult> describeEventTypesAsync(DescribeEventTypesRequest request, final AsyncHandler<DescribeEventTypesRequest, DescribeEventTypesResult> asyncHandler) {
        final DescribeEventTypesRequest finalRequest = (DescribeEventTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventTypesResult>(){

            @Override
            public DescribeEventTypesResult call() throws Exception {
                DescribeEventTypesResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEventTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        final DescribeEventsRequest finalRequest = (DescribeEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsForOrganizationResult> describeEventsForOrganizationAsync(DescribeEventsForOrganizationRequest request) {
        return this.describeEventsForOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeEventsForOrganizationResult> describeEventsForOrganizationAsync(DescribeEventsForOrganizationRequest request, final AsyncHandler<DescribeEventsForOrganizationRequest, DescribeEventsForOrganizationResult> asyncHandler) {
        final DescribeEventsForOrganizationRequest finalRequest = (DescribeEventsForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsForOrganizationResult>(){

            @Override
            public DescribeEventsForOrganizationResult call() throws Exception {
                DescribeEventsForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeEventsForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHealthServiceStatusForOrganizationResult> describeHealthServiceStatusForOrganizationAsync(DescribeHealthServiceStatusForOrganizationRequest request) {
        return this.describeHealthServiceStatusForOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeHealthServiceStatusForOrganizationResult> describeHealthServiceStatusForOrganizationAsync(DescribeHealthServiceStatusForOrganizationRequest request, final AsyncHandler<DescribeHealthServiceStatusForOrganizationRequest, DescribeHealthServiceStatusForOrganizationResult> asyncHandler) {
        final DescribeHealthServiceStatusForOrganizationRequest finalRequest = (DescribeHealthServiceStatusForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeHealthServiceStatusForOrganizationResult>(){

            @Override
            public DescribeHealthServiceStatusForOrganizationResult call() throws Exception {
                DescribeHealthServiceStatusForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDescribeHealthServiceStatusForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableHealthServiceAccessForOrganizationResult> disableHealthServiceAccessForOrganizationAsync(DisableHealthServiceAccessForOrganizationRequest request) {
        return this.disableHealthServiceAccessForOrganizationAsync(request, null);
    }

    @Override
    public Future<DisableHealthServiceAccessForOrganizationResult> disableHealthServiceAccessForOrganizationAsync(DisableHealthServiceAccessForOrganizationRequest request, final AsyncHandler<DisableHealthServiceAccessForOrganizationRequest, DisableHealthServiceAccessForOrganizationResult> asyncHandler) {
        final DisableHealthServiceAccessForOrganizationRequest finalRequest = (DisableHealthServiceAccessForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableHealthServiceAccessForOrganizationResult>(){

            @Override
            public DisableHealthServiceAccessForOrganizationResult call() throws Exception {
                DisableHealthServiceAccessForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeDisableHealthServiceAccessForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableHealthServiceAccessForOrganizationResult> enableHealthServiceAccessForOrganizationAsync(EnableHealthServiceAccessForOrganizationRequest request) {
        return this.enableHealthServiceAccessForOrganizationAsync(request, null);
    }

    @Override
    public Future<EnableHealthServiceAccessForOrganizationResult> enableHealthServiceAccessForOrganizationAsync(EnableHealthServiceAccessForOrganizationRequest request, final AsyncHandler<EnableHealthServiceAccessForOrganizationRequest, EnableHealthServiceAccessForOrganizationResult> asyncHandler) {
        final EnableHealthServiceAccessForOrganizationRequest finalRequest = (EnableHealthServiceAccessForOrganizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableHealthServiceAccessForOrganizationResult>(){

            @Override
            public EnableHealthServiceAccessForOrganizationResult call() throws Exception {
                EnableHealthServiceAccessForOrganizationResult result = null;
                try {
                    result = AWSHealthAsyncClient.this.executeEnableHealthServiceAccessForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

