/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.healthlake;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.healthlake.AmazonHealthLake;
import com.amazonaws.services.healthlake.AmazonHealthLakeClientBuilder;
import com.amazonaws.services.healthlake.model.AmazonHealthLakeException;
import com.amazonaws.services.healthlake.model.CreateFHIRDatastoreRequest;
import com.amazonaws.services.healthlake.model.CreateFHIRDatastoreResult;
import com.amazonaws.services.healthlake.model.DeleteFHIRDatastoreRequest;
import com.amazonaws.services.healthlake.model.DeleteFHIRDatastoreResult;
import com.amazonaws.services.healthlake.model.DescribeFHIRDatastoreRequest;
import com.amazonaws.services.healthlake.model.DescribeFHIRDatastoreResult;
import com.amazonaws.services.healthlake.model.DescribeFHIRExportJobRequest;
import com.amazonaws.services.healthlake.model.DescribeFHIRExportJobResult;
import com.amazonaws.services.healthlake.model.DescribeFHIRImportJobRequest;
import com.amazonaws.services.healthlake.model.DescribeFHIRImportJobResult;
import com.amazonaws.services.healthlake.model.ListFHIRDatastoresRequest;
import com.amazonaws.services.healthlake.model.ListFHIRDatastoresResult;
import com.amazonaws.services.healthlake.model.StartFHIRExportJobRequest;
import com.amazonaws.services.healthlake.model.StartFHIRExportJobResult;
import com.amazonaws.services.healthlake.model.StartFHIRImportJobRequest;
import com.amazonaws.services.healthlake.model.StartFHIRImportJobResult;
import com.amazonaws.services.healthlake.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.CreateFHIRDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.CreateFHIRDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.DeleteFHIRDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.DeleteFHIRDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.DescribeFHIRDatastoreRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.DescribeFHIRDatastoreResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.DescribeFHIRExportJobRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.DescribeFHIRExportJobResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.DescribeFHIRImportJobRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.DescribeFHIRImportJobResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.ListFHIRDatastoresRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.ListFHIRDatastoresResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.StartFHIRExportJobRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.StartFHIRExportJobResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.StartFHIRImportJobRequestProtocolMarshaller;
import com.amazonaws.services.healthlake.model.transform.StartFHIRImportJobResultJsonUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.healthlake.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonHealthLakeClient
extends AmazonWebServiceClient
implements AmazonHealthLake {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonHealthLake.class);
    private static final String DEFAULT_SIGNING_NAME = "healthlake";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonHealthLakeException.class));

    public static AmazonHealthLakeClientBuilder builder() {
        return AmazonHealthLakeClientBuilder.standard();
    }

    AmazonHealthLakeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonHealthLakeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("healthlake.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/healthlake/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/healthlake/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateFHIRDatastoreResult createFHIRDatastore(CreateFHIRDatastoreRequest request) {
        request = (CreateFHIRDatastoreRequest)this.beforeClientExecution(request);
        return this.executeCreateFHIRDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFHIRDatastoreResult executeCreateFHIRDatastore(CreateFHIRDatastoreRequest createFHIRDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFHIRDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFHIRDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFHIRDatastoreRequestProtocolMarshaller(protocolFactory).marshall((CreateFHIRDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFHIRDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFHIRDatastore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFHIRDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFHIRDatastoreResult createFHIRDatastoreResult = (CreateFHIRDatastoreResult)response.getAwsResponse();
            return createFHIRDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFHIRDatastoreResult deleteFHIRDatastore(DeleteFHIRDatastoreRequest request) {
        request = (DeleteFHIRDatastoreRequest)this.beforeClientExecution(request);
        return this.executeDeleteFHIRDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFHIRDatastoreResult executeDeleteFHIRDatastore(DeleteFHIRDatastoreRequest deleteFHIRDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFHIRDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFHIRDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFHIRDatastoreRequestProtocolMarshaller(protocolFactory).marshall((DeleteFHIRDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFHIRDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteFHIRDatastore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFHIRDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFHIRDatastoreResult deleteFHIRDatastoreResult = (DeleteFHIRDatastoreResult)response.getAwsResponse();
            return deleteFHIRDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFHIRDatastoreResult describeFHIRDatastore(DescribeFHIRDatastoreRequest request) {
        request = (DescribeFHIRDatastoreRequest)this.beforeClientExecution(request);
        return this.executeDescribeFHIRDatastore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFHIRDatastoreResult executeDescribeFHIRDatastore(DescribeFHIRDatastoreRequest describeFHIRDatastoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFHIRDatastoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFHIRDatastoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFHIRDatastoreRequestProtocolMarshaller(protocolFactory).marshall((DescribeFHIRDatastoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFHIRDatastoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFHIRDatastore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFHIRDatastoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFHIRDatastoreResult describeFHIRDatastoreResult = (DescribeFHIRDatastoreResult)response.getAwsResponse();
            return describeFHIRDatastoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFHIRExportJobResult describeFHIRExportJob(DescribeFHIRExportJobRequest request) {
        request = (DescribeFHIRExportJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeFHIRExportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFHIRExportJobResult executeDescribeFHIRExportJob(DescribeFHIRExportJobRequest describeFHIRExportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFHIRExportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFHIRExportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFHIRExportJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeFHIRExportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFHIRExportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFHIRExportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFHIRExportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFHIRExportJobResult describeFHIRExportJobResult = (DescribeFHIRExportJobResult)response.getAwsResponse();
            return describeFHIRExportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFHIRImportJobResult describeFHIRImportJob(DescribeFHIRImportJobRequest request) {
        request = (DescribeFHIRImportJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeFHIRImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFHIRImportJobResult executeDescribeFHIRImportJob(DescribeFHIRImportJobRequest describeFHIRImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFHIRImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFHIRImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFHIRImportJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeFHIRImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFHIRImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFHIRImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFHIRImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFHIRImportJobResult describeFHIRImportJobResult = (DescribeFHIRImportJobResult)response.getAwsResponse();
            return describeFHIRImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFHIRDatastoresResult listFHIRDatastores(ListFHIRDatastoresRequest request) {
        request = (ListFHIRDatastoresRequest)this.beforeClientExecution(request);
        return this.executeListFHIRDatastores(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFHIRDatastoresResult executeListFHIRDatastores(ListFHIRDatastoresRequest listFHIRDatastoresRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFHIRDatastoresRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFHIRDatastoresRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFHIRDatastoresRequestProtocolMarshaller(protocolFactory).marshall((ListFHIRDatastoresRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFHIRDatastoresRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFHIRDatastores");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFHIRDatastoresResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFHIRDatastoresResult listFHIRDatastoresResult = (ListFHIRDatastoresResult)response.getAwsResponse();
            return listFHIRDatastoresResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFHIRExportJobResult startFHIRExportJob(StartFHIRExportJobRequest request) {
        request = (StartFHIRExportJobRequest)this.beforeClientExecution(request);
        return this.executeStartFHIRExportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFHIRExportJobResult executeStartFHIRExportJob(StartFHIRExportJobRequest startFHIRExportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFHIRExportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFHIRExportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFHIRExportJobRequestProtocolMarshaller(protocolFactory).marshall((StartFHIRExportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startFHIRExportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartFHIRExportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFHIRExportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFHIRExportJobResult startFHIRExportJobResult = (StartFHIRExportJobResult)response.getAwsResponse();
            return startFHIRExportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFHIRImportJobResult startFHIRImportJob(StartFHIRImportJobRequest request) {
        request = (StartFHIRImportJobRequest)this.beforeClientExecution(request);
        return this.executeStartFHIRImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFHIRImportJobResult executeStartFHIRImportJob(StartFHIRImportJobRequest startFHIRImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFHIRImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFHIRImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFHIRImportJobRequestProtocolMarshaller(protocolFactory).marshall((StartFHIRImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startFHIRImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"HealthLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartFHIRImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFHIRImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFHIRImportJobResult startFHIRImportJobResult = (StartFHIRImportJobResult)response.getAwsResponse();
            return startFHIRImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

