/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.healthlake.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.healthlake.model.S3Configuration;

@SdkInternalApi
public class S3ConfigurationMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final S3ConfigurationMarshaller instance = new S3ConfigurationMarshaller();

    public static S3ConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Configuration s3Configuration, ProtocolMarshaller protocolMarshaller) {
        if (s3Configuration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Configuration.getS3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall((Object)s3Configuration.getKmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

