/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.inspector.model.LocalizedText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocalizeTextRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<LocalizedText> localizedTexts;
    private String locale;

    public List<LocalizedText> getLocalizedTexts() {
        return this.localizedTexts;
    }

    public void setLocalizedTexts(Collection<LocalizedText> localizedTexts) {
        if (localizedTexts == null) {
            this.localizedTexts = null;
            return;
        }
        this.localizedTexts = new ArrayList<LocalizedText>(localizedTexts);
    }

    public LocalizeTextRequest withLocalizedTexts(LocalizedText ... localizedTexts) {
        if (this.localizedTexts == null) {
            this.setLocalizedTexts(new ArrayList<LocalizedText>(localizedTexts.length));
        }
        for (LocalizedText ele : localizedTexts) {
            this.localizedTexts.add(ele);
        }
        return this;
    }

    public LocalizeTextRequest withLocalizedTexts(Collection<LocalizedText> localizedTexts) {
        this.setLocalizedTexts(localizedTexts);
        return this;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public LocalizeTextRequest withLocale(String locale) {
        this.setLocale(locale);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocalizedTexts() != null) {
            sb.append("LocalizedTexts: " + this.getLocalizedTexts() + ",");
        }
        if (this.getLocale() != null) {
            sb.append("Locale: " + this.getLocale());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalizeTextRequest)) {
            return false;
        }
        LocalizeTextRequest other = (LocalizeTextRequest)obj;
        if (other.getLocalizedTexts() == null ^ this.getLocalizedTexts() == null) {
            return false;
        }
        if (other.getLocalizedTexts() != null && !other.getLocalizedTexts().equals(this.getLocalizedTexts())) {
            return false;
        }
        if (other.getLocale() == null ^ this.getLocale() == null) {
            return false;
        }
        return other.getLocale() == null || other.getLocale().equals(this.getLocale());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocalizedTexts() == null ? 0 : this.getLocalizedTexts().hashCode());
        hashCode = 31 * hashCode + (this.getLocale() == null ? 0 : this.getLocale().hashCode());
        return hashCode;
    }

    public LocalizeTextRequest clone() {
        return (LocalizeTextRequest)super.clone();
    }
}

