/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Agent;
import com.amazonaws.services.inspector.model.Telemetry;
import com.amazonaws.services.inspector.model.transform.TelemetryJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class AgentJsonMarshaller {
    private static AgentJsonMarshaller instance;

    public void marshall(Agent agent, JSONWriter jsonWriter) {
        if (agent == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Telemetry> telemetryList;
            jsonWriter.object();
            if (agent.getAgentId() != null) {
                jsonWriter.key("agentId").value((Object)agent.getAgentId());
            }
            if (agent.getAssessmentArn() != null) {
                jsonWriter.key("assessmentArn").value((Object)agent.getAssessmentArn());
            }
            if (agent.getAgentHealth() != null) {
                jsonWriter.key("agentHealth").value((Object)agent.getAgentHealth());
            }
            if (agent.getAgentHealthCode() != null) {
                jsonWriter.key("agentHealthCode").value((Object)agent.getAgentHealthCode());
            }
            if (agent.getAgentHealthDetails() != null) {
                jsonWriter.key("agentHealthDetails").value((Object)agent.getAgentHealthDetails());
            }
            if (agent.getAutoScalingGroup() != null) {
                jsonWriter.key("autoScalingGroup").value((Object)agent.getAutoScalingGroup());
            }
            if (agent.getAccountId() != null) {
                jsonWriter.key("accountId").value((Object)agent.getAccountId());
            }
            if ((telemetryList = agent.getTelemetry()) != null) {
                jsonWriter.key("telemetry");
                jsonWriter.array();
                for (Telemetry telemetryListValue : telemetryList) {
                    if (telemetryListValue == null) continue;
                    TelemetryJsonMarshaller.getInstance().marshall(telemetryListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AgentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AgentJsonMarshaller();
        }
        return instance;
    }
}

