/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.transform.FindingsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class ListFindingsRequestMarshaller
implements Marshaller<Request<ListFindingsRequest>, ListFindingsRequest> {
    public Request<ListFindingsRequest> marshall(ListFindingsRequest listFindingsRequest) {
        if (listFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            List<String> runArnsList = listFindingsRequest.getRunArns();
            if (runArnsList != null) {
                jsonWriter.key("runArns");
                jsonWriter.array();
                for (String runArnsListValue : runArnsList) {
                    if (runArnsListValue == null) continue;
                    jsonWriter.value((Object)runArnsListValue);
                }
                jsonWriter.endArray();
            }
            if (listFindingsRequest.getFilter() != null) {
                jsonWriter.key("filter");
                FindingsFilterJsonMarshaller.getInstance().marshall(listFindingsRequest.getFilter(), jsonWriter);
            }
            if (listFindingsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value((Object)listFindingsRequest.getNextToken());
            }
            if (listFindingsRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value((Object)listFindingsRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

