/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.inspector2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CodeVulnerabilityDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CodeVulnerabilityDetailsJsonUnmarshaller implements Unmarshaller<CodeVulnerabilityDetails, JsonUnmarshallerContext> {

    public CodeVulnerabilityDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        CodeVulnerabilityDetails codeVulnerabilityDetails = new CodeVulnerabilityDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("cwes", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setCwes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("detectorId", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setDetectorId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("detectorName", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setDetectorName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("detectorTags", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setDetectorTags(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("filePath", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setFilePath(CodeFilePathJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("referenceUrls", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setReferenceUrls(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("ruleId", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setRuleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sourceLambdaLayerArn", targetDepth)) {
                    context.nextToken();
                    codeVulnerabilityDetails.setSourceLambdaLayerArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return codeVulnerabilityDetails;
    }

    private static CodeVulnerabilityDetailsJsonUnmarshaller instance;

    public static CodeVulnerabilityDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new CodeVulnerabilityDetailsJsonUnmarshaller();
        return instance;
    }
}
