/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.IngestConfiguration;

@SdkInternalApi
public class IngestConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audio").build();
    private static final MarshallingInfo<StructuredPojo> VIDEO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("video").build();
    private static final IngestConfigurationMarshaller instance = new IngestConfigurationMarshaller();

    public static IngestConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(IngestConfiguration ingestConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (ingestConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ingestConfiguration.getAudio(), AUDIO_BINDING);
            protocolMarshaller.marshall((Object)ingestConfiguration.getVideo(), VIDEO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

