/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.Sasl;

@SdkInternalApi
public class SaslMarshaller {
    private static final MarshallingInfo<StructuredPojo> SCRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scram").build();
    private static final SaslMarshaller instance = new SaslMarshaller();

    public static SaslMarshaller getInstance() {
        return instance;
    }

    public void marshall(Sasl sasl, ProtocolMarshaller protocolMarshaller) {
        if (sasl == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sasl.getScram(), SCRAM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

