/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kendra.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.kendra.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateIndexRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateIndexRequestMarshaller {

    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> DOCUMENTMETADATACONFIGURATIONUPDATES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentMetadataConfigurationUpdates").build();
    private static final MarshallingInfo<StructuredPojo> CAPACITYUNITS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityUnits").build();
    private static final MarshallingInfo<List> USERTOKENCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserTokenConfigurations").build();
    private static final MarshallingInfo<String> USERCONTEXTPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserContextPolicy").build();

    private static final UpdateIndexRequestMarshaller instance = new UpdateIndexRequestMarshaller();

    public static UpdateIndexRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateIndexRequest updateIndexRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateIndexRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateIndexRequest.getId(), ID_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getDocumentMetadataConfigurationUpdates(), DOCUMENTMETADATACONFIGURATIONUPDATES_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getCapacityUnits(), CAPACITYUNITS_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getUserTokenConfigurations(), USERTOKENCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(updateIndexRequest.getUserContextPolicy(), USERCONTEXTPOLICY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
