/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.AdditionalResultAttribute;
import com.amazonaws.services.kendra.model.DocumentAttribute;
import com.amazonaws.services.kendra.model.QueryResultType;
import com.amazonaws.services.kendra.model.ScoreAttributes;
import com.amazonaws.services.kendra.model.TextWithHighlights;
import com.amazonaws.services.kendra.model.transform.QueryResultItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryResultItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String type;
    private List<AdditionalResultAttribute> additionalAttributes;
    private String documentId;
    private TextWithHighlights documentTitle;
    private TextWithHighlights documentExcerpt;
    private String documentURI;
    private List<DocumentAttribute> documentAttributes;
    private ScoreAttributes scoreAttributes;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public QueryResultItem withId(String id) {
        this.setId(id);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public QueryResultItem withType(String type) {
        this.setType(type);
        return this;
    }

    public QueryResultItem withType(QueryResultType type) {
        this.type = type.toString();
        return this;
    }

    public List<AdditionalResultAttribute> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
        if (additionalAttributes == null) {
            this.additionalAttributes = null;
            return;
        }
        this.additionalAttributes = new ArrayList<AdditionalResultAttribute>(additionalAttributes);
    }

    public QueryResultItem withAdditionalAttributes(AdditionalResultAttribute ... additionalAttributes) {
        if (this.additionalAttributes == null) {
            this.setAdditionalAttributes(new ArrayList<AdditionalResultAttribute>(additionalAttributes.length));
        }
        for (AdditionalResultAttribute ele : additionalAttributes) {
            this.additionalAttributes.add(ele);
        }
        return this;
    }

    public QueryResultItem withAdditionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
        this.setAdditionalAttributes(additionalAttributes);
        return this;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public QueryResultItem withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public void setDocumentTitle(TextWithHighlights documentTitle) {
        this.documentTitle = documentTitle;
    }

    public TextWithHighlights getDocumentTitle() {
        return this.documentTitle;
    }

    public QueryResultItem withDocumentTitle(TextWithHighlights documentTitle) {
        this.setDocumentTitle(documentTitle);
        return this;
    }

    public void setDocumentExcerpt(TextWithHighlights documentExcerpt) {
        this.documentExcerpt = documentExcerpt;
    }

    public TextWithHighlights getDocumentExcerpt() {
        return this.documentExcerpt;
    }

    public QueryResultItem withDocumentExcerpt(TextWithHighlights documentExcerpt) {
        this.setDocumentExcerpt(documentExcerpt);
        return this;
    }

    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public QueryResultItem withDocumentURI(String documentURI) {
        this.setDocumentURI(documentURI);
        return this;
    }

    public List<DocumentAttribute> getDocumentAttributes() {
        return this.documentAttributes;
    }

    public void setDocumentAttributes(Collection<DocumentAttribute> documentAttributes) {
        if (documentAttributes == null) {
            this.documentAttributes = null;
            return;
        }
        this.documentAttributes = new ArrayList<DocumentAttribute>(documentAttributes);
    }

    public QueryResultItem withDocumentAttributes(DocumentAttribute ... documentAttributes) {
        if (this.documentAttributes == null) {
            this.setDocumentAttributes(new ArrayList<DocumentAttribute>(documentAttributes.length));
        }
        for (DocumentAttribute ele : documentAttributes) {
            this.documentAttributes.add(ele);
        }
        return this;
    }

    public QueryResultItem withDocumentAttributes(Collection<DocumentAttribute> documentAttributes) {
        this.setDocumentAttributes(documentAttributes);
        return this;
    }

    public void setScoreAttributes(ScoreAttributes scoreAttributes) {
        this.scoreAttributes = scoreAttributes;
    }

    public ScoreAttributes getScoreAttributes() {
        return this.scoreAttributes;
    }

    public QueryResultItem withScoreAttributes(ScoreAttributes scoreAttributes) {
        this.setScoreAttributes(scoreAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getAdditionalAttributes() != null) {
            sb.append("AdditionalAttributes: ").append(this.getAdditionalAttributes()).append(",");
        }
        if (this.getDocumentId() != null) {
            sb.append("DocumentId: ").append(this.getDocumentId()).append(",");
        }
        if (this.getDocumentTitle() != null) {
            sb.append("DocumentTitle: ").append(this.getDocumentTitle()).append(",");
        }
        if (this.getDocumentExcerpt() != null) {
            sb.append("DocumentExcerpt: ").append(this.getDocumentExcerpt()).append(",");
        }
        if (this.getDocumentURI() != null) {
            sb.append("DocumentURI: ").append(this.getDocumentURI()).append(",");
        }
        if (this.getDocumentAttributes() != null) {
            sb.append("DocumentAttributes: ").append(this.getDocumentAttributes()).append(",");
        }
        if (this.getScoreAttributes() != null) {
            sb.append("ScoreAttributes: ").append(this.getScoreAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultItem)) {
            return false;
        }
        QueryResultItem other = (QueryResultItem)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAdditionalAttributes() == null ^ this.getAdditionalAttributes() == null) {
            return false;
        }
        if (other.getAdditionalAttributes() != null && !other.getAdditionalAttributes().equals(this.getAdditionalAttributes())) {
            return false;
        }
        if (other.getDocumentId() == null ^ this.getDocumentId() == null) {
            return false;
        }
        if (other.getDocumentId() != null && !other.getDocumentId().equals(this.getDocumentId())) {
            return false;
        }
        if (other.getDocumentTitle() == null ^ this.getDocumentTitle() == null) {
            return false;
        }
        if (other.getDocumentTitle() != null && !other.getDocumentTitle().equals(this.getDocumentTitle())) {
            return false;
        }
        if (other.getDocumentExcerpt() == null ^ this.getDocumentExcerpt() == null) {
            return false;
        }
        if (other.getDocumentExcerpt() != null && !other.getDocumentExcerpt().equals(this.getDocumentExcerpt())) {
            return false;
        }
        if (other.getDocumentURI() == null ^ this.getDocumentURI() == null) {
            return false;
        }
        if (other.getDocumentURI() != null && !other.getDocumentURI().equals(this.getDocumentURI())) {
            return false;
        }
        if (other.getDocumentAttributes() == null ^ this.getDocumentAttributes() == null) {
            return false;
        }
        if (other.getDocumentAttributes() != null && !other.getDocumentAttributes().equals(this.getDocumentAttributes())) {
            return false;
        }
        if (other.getScoreAttributes() == null ^ this.getScoreAttributes() == null) {
            return false;
        }
        return other.getScoreAttributes() == null || other.getScoreAttributes().equals(this.getScoreAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalAttributes() == null ? 0 : this.getAdditionalAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentId() == null ? 0 : this.getDocumentId().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentTitle() == null ? 0 : this.getDocumentTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentExcerpt() == null ? 0 : this.getDocumentExcerpt().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentURI() == null ? 0 : this.getDocumentURI().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentAttributes() == null ? 0 : this.getDocumentAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getScoreAttributes() == null ? 0 : this.getScoreAttributes().hashCode());
        return hashCode;
    }

    public QueryResultItem clone() {
        try {
            return (QueryResultItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryResultItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

