/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.JwtTokenTypeConfiguration;

@SdkInternalApi
public class JwtTokenTypeConfigurationMarshaller {
    private static final MarshallingInfo<String> KEYLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyLocation").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("URL").build();
    private static final MarshallingInfo<String> SECRETMANAGERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretManagerArn").build();
    private static final MarshallingInfo<String> USERNAMEATTRIBUTEFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserNameAttributeField").build();
    private static final MarshallingInfo<String> GROUPATTRIBUTEFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupAttributeField").build();
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issuer").build();
    private static final MarshallingInfo<String> CLAIMREGEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClaimRegex").build();
    private static final JwtTokenTypeConfigurationMarshaller instance = new JwtTokenTypeConfigurationMarshaller();

    public static JwtTokenTypeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(JwtTokenTypeConfiguration jwtTokenTypeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (jwtTokenTypeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getKeyLocation(), KEYLOCATION_BINDING);
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getURL(), URL_BINDING);
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getSecretManagerArn(), SECRETMANAGERARN_BINDING);
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getUserNameAttributeField(), USERNAMEATTRIBUTEFIELD_BINDING);
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getGroupAttributeField(), GROUPATTRIBUTEFIELD_BINDING);
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getIssuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)jwtTokenTypeConfiguration.getClaimRegex(), CLAIMREGEX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

