/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lakeformation.AWSLakeFormationAsync;
import com.amazonaws.services.lakeformation.AWSLakeFormationAsyncClientBuilder;
import com.amazonaws.services.lakeformation.AWSLakeFormationClient;
import com.amazonaws.services.lakeformation.model.AddLFTagsToResourceRequest;
import com.amazonaws.services.lakeformation.model.AddLFTagsToResourceResult;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.CreateLFTagRequest;
import com.amazonaws.services.lakeformation.model.CreateLFTagResult;
import com.amazonaws.services.lakeformation.model.DeleteLFTagRequest;
import com.amazonaws.services.lakeformation.model.DeleteLFTagResult;
import com.amazonaws.services.lakeformation.model.DeregisterResourceRequest;
import com.amazonaws.services.lakeformation.model.DeregisterResourceResult;
import com.amazonaws.services.lakeformation.model.DescribeResourceRequest;
import com.amazonaws.services.lakeformation.model.DescribeResourceResult;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathResult;
import com.amazonaws.services.lakeformation.model.GetLFTagRequest;
import com.amazonaws.services.lakeformation.model.GetLFTagResult;
import com.amazonaws.services.lakeformation.model.GetResourceLFTagsRequest;
import com.amazonaws.services.lakeformation.model.GetResourceLFTagsResult;
import com.amazonaws.services.lakeformation.model.GrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.GrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListLFTagsRequest;
import com.amazonaws.services.lakeformation.model.ListLFTagsResult;
import com.amazonaws.services.lakeformation.model.ListPermissionsRequest;
import com.amazonaws.services.lakeformation.model.ListPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListResourcesRequest;
import com.amazonaws.services.lakeformation.model.ListResourcesResult;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.RegisterResourceRequest;
import com.amazonaws.services.lakeformation.model.RegisterResourceResult;
import com.amazonaws.services.lakeformation.model.RemoveLFTagsFromResourceRequest;
import com.amazonaws.services.lakeformation.model.RemoveLFTagsFromResourceResult;
import com.amazonaws.services.lakeformation.model.RevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.RevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.SearchDatabasesByLFTagsRequest;
import com.amazonaws.services.lakeformation.model.SearchDatabasesByLFTagsResult;
import com.amazonaws.services.lakeformation.model.SearchTablesByLFTagsRequest;
import com.amazonaws.services.lakeformation.model.SearchTablesByLFTagsResult;
import com.amazonaws.services.lakeformation.model.UpdateLFTagRequest;
import com.amazonaws.services.lakeformation.model.UpdateLFTagResult;
import com.amazonaws.services.lakeformation.model.UpdateResourceRequest;
import com.amazonaws.services.lakeformation.model.UpdateResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLakeFormationAsyncClient
extends AWSLakeFormationClient
implements AWSLakeFormationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSLakeFormationAsyncClientBuilder asyncBuilder() {
        return AWSLakeFormationAsyncClientBuilder.standard();
    }

    AWSLakeFormationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSLakeFormationAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddLFTagsToResourceResult> addLFTagsToResourceAsync(AddLFTagsToResourceRequest request) {
        return this.addLFTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddLFTagsToResourceResult> addLFTagsToResourceAsync(AddLFTagsToResourceRequest request, final AsyncHandler<AddLFTagsToResourceRequest, AddLFTagsToResourceResult> asyncHandler) {
        final AddLFTagsToResourceRequest finalRequest = (AddLFTagsToResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddLFTagsToResourceResult>(){

            @Override
            public AddLFTagsToResourceResult call() throws Exception {
                AddLFTagsToResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeAddLFTagsToResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGrantPermissionsResult> batchGrantPermissionsAsync(BatchGrantPermissionsRequest request) {
        return this.batchGrantPermissionsAsync(request, null);
    }

    @Override
    public Future<BatchGrantPermissionsResult> batchGrantPermissionsAsync(BatchGrantPermissionsRequest request, final AsyncHandler<BatchGrantPermissionsRequest, BatchGrantPermissionsResult> asyncHandler) {
        final BatchGrantPermissionsRequest finalRequest = (BatchGrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGrantPermissionsResult>(){

            @Override
            public BatchGrantPermissionsResult call() throws Exception {
                BatchGrantPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeBatchGrantPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchRevokePermissionsResult> batchRevokePermissionsAsync(BatchRevokePermissionsRequest request) {
        return this.batchRevokePermissionsAsync(request, null);
    }

    @Override
    public Future<BatchRevokePermissionsResult> batchRevokePermissionsAsync(BatchRevokePermissionsRequest request, final AsyncHandler<BatchRevokePermissionsRequest, BatchRevokePermissionsResult> asyncHandler) {
        final BatchRevokePermissionsRequest finalRequest = (BatchRevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchRevokePermissionsResult>(){

            @Override
            public BatchRevokePermissionsResult call() throws Exception {
                BatchRevokePermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeBatchRevokePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLFTagResult> createLFTagAsync(CreateLFTagRequest request) {
        return this.createLFTagAsync(request, null);
    }

    @Override
    public Future<CreateLFTagResult> createLFTagAsync(CreateLFTagRequest request, final AsyncHandler<CreateLFTagRequest, CreateLFTagResult> asyncHandler) {
        final CreateLFTagRequest finalRequest = (CreateLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLFTagResult>(){

            @Override
            public CreateLFTagResult call() throws Exception {
                CreateLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeCreateLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLFTagResult> deleteLFTagAsync(DeleteLFTagRequest request) {
        return this.deleteLFTagAsync(request, null);
    }

    @Override
    public Future<DeleteLFTagResult> deleteLFTagAsync(DeleteLFTagRequest request, final AsyncHandler<DeleteLFTagRequest, DeleteLFTagResult> asyncHandler) {
        final DeleteLFTagRequest finalRequest = (DeleteLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLFTagResult>(){

            @Override
            public DeleteLFTagResult call() throws Exception {
                DeleteLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeleteLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterResourceResult> deregisterResourceAsync(DeregisterResourceRequest request) {
        return this.deregisterResourceAsync(request, null);
    }

    @Override
    public Future<DeregisterResourceResult> deregisterResourceAsync(DeregisterResourceRequest request, final AsyncHandler<DeregisterResourceRequest, DeregisterResourceResult> asyncHandler) {
        final DeregisterResourceRequest finalRequest = (DeregisterResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterResourceResult>(){

            @Override
            public DeregisterResourceResult call() throws Exception {
                DeregisterResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeregisterResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourceResult> describeResourceAsync(DescribeResourceRequest request) {
        return this.describeResourceAsync(request, null);
    }

    @Override
    public Future<DescribeResourceResult> describeResourceAsync(DescribeResourceRequest request, final AsyncHandler<DescribeResourceRequest, DescribeResourceResult> asyncHandler) {
        final DescribeResourceRequest finalRequest = (DescribeResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeResourceResult>(){

            @Override
            public DescribeResourceResult call() throws Exception {
                DescribeResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDescribeResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataLakeSettingsResult> getDataLakeSettingsAsync(GetDataLakeSettingsRequest request) {
        return this.getDataLakeSettingsAsync(request, null);
    }

    @Override
    public Future<GetDataLakeSettingsResult> getDataLakeSettingsAsync(GetDataLakeSettingsRequest request, final AsyncHandler<GetDataLakeSettingsRequest, GetDataLakeSettingsResult> asyncHandler) {
        final GetDataLakeSettingsRequest finalRequest = (GetDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataLakeSettingsResult>(){

            @Override
            public GetDataLakeSettingsResult call() throws Exception {
                GetDataLakeSettingsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetDataLakeSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEffectivePermissionsForPathResult> getEffectivePermissionsForPathAsync(GetEffectivePermissionsForPathRequest request) {
        return this.getEffectivePermissionsForPathAsync(request, null);
    }

    @Override
    public Future<GetEffectivePermissionsForPathResult> getEffectivePermissionsForPathAsync(GetEffectivePermissionsForPathRequest request, final AsyncHandler<GetEffectivePermissionsForPathRequest, GetEffectivePermissionsForPathResult> asyncHandler) {
        final GetEffectivePermissionsForPathRequest finalRequest = (GetEffectivePermissionsForPathRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEffectivePermissionsForPathResult>(){

            @Override
            public GetEffectivePermissionsForPathResult call() throws Exception {
                GetEffectivePermissionsForPathResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetEffectivePermissionsForPath(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLFTagResult> getLFTagAsync(GetLFTagRequest request) {
        return this.getLFTagAsync(request, null);
    }

    @Override
    public Future<GetLFTagResult> getLFTagAsync(GetLFTagRequest request, final AsyncHandler<GetLFTagRequest, GetLFTagResult> asyncHandler) {
        final GetLFTagRequest finalRequest = (GetLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLFTagResult>(){

            @Override
            public GetLFTagResult call() throws Exception {
                GetLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceLFTagsResult> getResourceLFTagsAsync(GetResourceLFTagsRequest request) {
        return this.getResourceLFTagsAsync(request, null);
    }

    @Override
    public Future<GetResourceLFTagsResult> getResourceLFTagsAsync(GetResourceLFTagsRequest request, final AsyncHandler<GetResourceLFTagsRequest, GetResourceLFTagsResult> asyncHandler) {
        final GetResourceLFTagsRequest finalRequest = (GetResourceLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceLFTagsResult>(){

            @Override
            public GetResourceLFTagsResult call() throws Exception {
                GetResourceLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetResourceLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GrantPermissionsResult> grantPermissionsAsync(GrantPermissionsRequest request) {
        return this.grantPermissionsAsync(request, null);
    }

    @Override
    public Future<GrantPermissionsResult> grantPermissionsAsync(GrantPermissionsRequest request, final AsyncHandler<GrantPermissionsRequest, GrantPermissionsResult> asyncHandler) {
        final GrantPermissionsRequest finalRequest = (GrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GrantPermissionsResult>(){

            @Override
            public GrantPermissionsResult call() throws Exception {
                GrantPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGrantPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLFTagsResult> listLFTagsAsync(ListLFTagsRequest request) {
        return this.listLFTagsAsync(request, null);
    }

    @Override
    public Future<ListLFTagsResult> listLFTagsAsync(ListLFTagsRequest request, final AsyncHandler<ListLFTagsRequest, ListLFTagsResult> asyncHandler) {
        final ListLFTagsRequest finalRequest = (ListLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLFTagsResult>(){

            @Override
            public ListLFTagsResult call() throws Exception {
                ListLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request) {
        return this.listPermissionsAsync(request, null);
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request, final AsyncHandler<ListPermissionsRequest, ListPermissionsResult> asyncHandler) {
        final ListPermissionsRequest finalRequest = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionsResult>(){

            @Override
            public ListPermissionsResult call() throws Exception {
                ListPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request) {
        return this.listResourcesAsync(request, null);
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request, final AsyncHandler<ListResourcesRequest, ListResourcesResult> asyncHandler) {
        final ListResourcesRequest finalRequest = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesResult>(){

            @Override
            public ListResourcesResult call() throws Exception {
                ListResourcesResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDataLakeSettingsResult> putDataLakeSettingsAsync(PutDataLakeSettingsRequest request) {
        return this.putDataLakeSettingsAsync(request, null);
    }

    @Override
    public Future<PutDataLakeSettingsResult> putDataLakeSettingsAsync(PutDataLakeSettingsRequest request, final AsyncHandler<PutDataLakeSettingsRequest, PutDataLakeSettingsResult> asyncHandler) {
        final PutDataLakeSettingsRequest finalRequest = (PutDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDataLakeSettingsResult>(){

            @Override
            public PutDataLakeSettingsResult call() throws Exception {
                PutDataLakeSettingsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executePutDataLakeSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterResourceResult> registerResourceAsync(RegisterResourceRequest request) {
        return this.registerResourceAsync(request, null);
    }

    @Override
    public Future<RegisterResourceResult> registerResourceAsync(RegisterResourceRequest request, final AsyncHandler<RegisterResourceRequest, RegisterResourceResult> asyncHandler) {
        final RegisterResourceRequest finalRequest = (RegisterResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterResourceResult>(){

            @Override
            public RegisterResourceResult call() throws Exception {
                RegisterResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRegisterResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveLFTagsFromResourceResult> removeLFTagsFromResourceAsync(RemoveLFTagsFromResourceRequest request) {
        return this.removeLFTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveLFTagsFromResourceResult> removeLFTagsFromResourceAsync(RemoveLFTagsFromResourceRequest request, final AsyncHandler<RemoveLFTagsFromResourceRequest, RemoveLFTagsFromResourceResult> asyncHandler) {
        final RemoveLFTagsFromResourceRequest finalRequest = (RemoveLFTagsFromResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveLFTagsFromResourceResult>(){

            @Override
            public RemoveLFTagsFromResourceResult call() throws Exception {
                RemoveLFTagsFromResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRemoveLFTagsFromResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokePermissionsResult> revokePermissionsAsync(RevokePermissionsRequest request) {
        return this.revokePermissionsAsync(request, null);
    }

    @Override
    public Future<RevokePermissionsResult> revokePermissionsAsync(RevokePermissionsRequest request, final AsyncHandler<RevokePermissionsRequest, RevokePermissionsResult> asyncHandler) {
        final RevokePermissionsRequest finalRequest = (RevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokePermissionsResult>(){

            @Override
            public RevokePermissionsResult call() throws Exception {
                RevokePermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRevokePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchDatabasesByLFTagsResult> searchDatabasesByLFTagsAsync(SearchDatabasesByLFTagsRequest request) {
        return this.searchDatabasesByLFTagsAsync(request, null);
    }

    @Override
    public Future<SearchDatabasesByLFTagsResult> searchDatabasesByLFTagsAsync(SearchDatabasesByLFTagsRequest request, final AsyncHandler<SearchDatabasesByLFTagsRequest, SearchDatabasesByLFTagsResult> asyncHandler) {
        final SearchDatabasesByLFTagsRequest finalRequest = (SearchDatabasesByLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchDatabasesByLFTagsResult>(){

            @Override
            public SearchDatabasesByLFTagsResult call() throws Exception {
                SearchDatabasesByLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeSearchDatabasesByLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchTablesByLFTagsResult> searchTablesByLFTagsAsync(SearchTablesByLFTagsRequest request) {
        return this.searchTablesByLFTagsAsync(request, null);
    }

    @Override
    public Future<SearchTablesByLFTagsResult> searchTablesByLFTagsAsync(SearchTablesByLFTagsRequest request, final AsyncHandler<SearchTablesByLFTagsRequest, SearchTablesByLFTagsResult> asyncHandler) {
        final SearchTablesByLFTagsRequest finalRequest = (SearchTablesByLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchTablesByLFTagsResult>(){

            @Override
            public SearchTablesByLFTagsResult call() throws Exception {
                SearchTablesByLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeSearchTablesByLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLFTagResult> updateLFTagAsync(UpdateLFTagRequest request) {
        return this.updateLFTagAsync(request, null);
    }

    @Override
    public Future<UpdateLFTagResult> updateLFTagAsync(UpdateLFTagRequest request, final AsyncHandler<UpdateLFTagRequest, UpdateLFTagResult> asyncHandler) {
        final UpdateLFTagRequest finalRequest = (UpdateLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLFTagResult>(){

            @Override
            public UpdateLFTagResult call() throws Exception {
                UpdateLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request) {
        return this.updateResourceAsync(request, null);
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request, final AsyncHandler<UpdateResourceRequest, UpdateResourceResult> asyncHandler) {
        final UpdateResourceRequest finalRequest = (UpdateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResourceResult>(){

            @Override
            public UpdateResourceResult call() throws Exception {
                UpdateResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

