/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeAsync;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeAsyncClientBuilder;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeClient;
import com.amazonaws.services.lexruntime.model.DeleteSessionRequest;
import com.amazonaws.services.lexruntime.model.DeleteSessionResult;
import com.amazonaws.services.lexruntime.model.GetSessionRequest;
import com.amazonaws.services.lexruntime.model.GetSessionResult;
import com.amazonaws.services.lexruntime.model.PostContentRequest;
import com.amazonaws.services.lexruntime.model.PostContentResult;
import com.amazonaws.services.lexruntime.model.PostTextRequest;
import com.amazonaws.services.lexruntime.model.PostTextResult;
import com.amazonaws.services.lexruntime.model.PutSessionRequest;
import com.amazonaws.services.lexruntime.model.PutSessionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonLexRuntimeAsyncClient
extends AmazonLexRuntimeClient
implements AmazonLexRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonLexRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonLexRuntimeAsyncClientBuilder.standard();
    }

    AmazonLexRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteSessionResult> deleteSessionAsync(DeleteSessionRequest request) {
        return this.deleteSessionAsync(request, null);
    }

    @Override
    public Future<DeleteSessionResult> deleteSessionAsync(DeleteSessionRequest request, final AsyncHandler<DeleteSessionRequest, DeleteSessionResult> asyncHandler) {
        final DeleteSessionRequest finalRequest = (DeleteSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSessionResult>(){

            @Override
            public DeleteSessionResult call() throws Exception {
                DeleteSessionResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executeDeleteSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionResult> getSessionAsync(GetSessionRequest request) {
        return this.getSessionAsync(request, null);
    }

    @Override
    public Future<GetSessionResult> getSessionAsync(GetSessionRequest request, final AsyncHandler<GetSessionRequest, GetSessionResult> asyncHandler) {
        final GetSessionRequest finalRequest = (GetSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSessionResult>(){

            @Override
            public GetSessionResult call() throws Exception {
                GetSessionResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executeGetSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PostContentResult> postContentAsync(PostContentRequest request) {
        return this.postContentAsync(request, null);
    }

    @Override
    public Future<PostContentResult> postContentAsync(PostContentRequest request, final AsyncHandler<PostContentRequest, PostContentResult> asyncHandler) {
        final PostContentRequest finalRequest = (PostContentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PostContentResult>(){

            @Override
            public PostContentResult call() throws Exception {
                PostContentResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executePostContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PostTextResult> postTextAsync(PostTextRequest request) {
        return this.postTextAsync(request, null);
    }

    @Override
    public Future<PostTextResult> postTextAsync(PostTextRequest request, final AsyncHandler<PostTextRequest, PostTextResult> asyncHandler) {
        final PostTextRequest finalRequest = (PostTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PostTextResult>(){

            @Override
            public PostTextResult call() throws Exception {
                PostTextResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executePostText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSessionResult> putSessionAsync(PutSessionRequest request) {
        return this.putSessionAsync(request, null);
    }

    @Override
    public Future<PutSessionResult> putSessionAsync(PutSessionRequest request, final AsyncHandler<PutSessionRequest, PutSessionResult> asyncHandler) {
        final PutSessionRequest finalRequest = (PutSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSessionResult>(){

            @Override
            public PutSessionResult call() throws Exception {
                PutSessionResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executePutSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

