/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.AllowedOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGrantRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String grantName;
    private String licenseArn;
    private List<String> principals;
    private String homeRegion;
    private List<String> allowedOperations;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateGrantRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setGrantName(String grantName) {
        this.grantName = grantName;
    }

    public String getGrantName() {
        return this.grantName;
    }

    public CreateGrantRequest withGrantName(String grantName) {
        this.setGrantName(grantName);
        return this;
    }

    public void setLicenseArn(String licenseArn) {
        this.licenseArn = licenseArn;
    }

    public String getLicenseArn() {
        return this.licenseArn;
    }

    public CreateGrantRequest withLicenseArn(String licenseArn) {
        this.setLicenseArn(licenseArn);
        return this;
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<String> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<String>(principals);
    }

    public CreateGrantRequest withPrincipals(String ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<String>(principals.length));
        }
        for (String ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public CreateGrantRequest withPrincipals(Collection<String> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public void setHomeRegion(String homeRegion) {
        this.homeRegion = homeRegion;
    }

    public String getHomeRegion() {
        return this.homeRegion;
    }

    public CreateGrantRequest withHomeRegion(String homeRegion) {
        this.setHomeRegion(homeRegion);
        return this;
    }

    public List<String> getAllowedOperations() {
        return this.allowedOperations;
    }

    public void setAllowedOperations(Collection<String> allowedOperations) {
        if (allowedOperations == null) {
            this.allowedOperations = null;
            return;
        }
        this.allowedOperations = new ArrayList<String>(allowedOperations);
    }

    public CreateGrantRequest withAllowedOperations(String ... allowedOperations) {
        if (this.allowedOperations == null) {
            this.setAllowedOperations(new ArrayList<String>(allowedOperations.length));
        }
        for (String ele : allowedOperations) {
            this.allowedOperations.add(ele);
        }
        return this;
    }

    public CreateGrantRequest withAllowedOperations(Collection<String> allowedOperations) {
        this.setAllowedOperations(allowedOperations);
        return this;
    }

    public CreateGrantRequest withAllowedOperations(AllowedOperation ... allowedOperations) {
        ArrayList<String> allowedOperationsCopy = new ArrayList<String>(allowedOperations.length);
        for (AllowedOperation value : allowedOperations) {
            allowedOperationsCopy.add(value.toString());
        }
        if (this.getAllowedOperations() == null) {
            this.setAllowedOperations(allowedOperationsCopy);
        } else {
            this.getAllowedOperations().addAll(allowedOperationsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getGrantName() != null) {
            sb.append("GrantName: ").append(this.getGrantName()).append(",");
        }
        if (this.getLicenseArn() != null) {
            sb.append("LicenseArn: ").append(this.getLicenseArn()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals()).append(",");
        }
        if (this.getHomeRegion() != null) {
            sb.append("HomeRegion: ").append(this.getHomeRegion()).append(",");
        }
        if (this.getAllowedOperations() != null) {
            sb.append("AllowedOperations: ").append(this.getAllowedOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getGrantName() == null ^ this.getGrantName() == null) {
            return false;
        }
        if (other.getGrantName() != null && !other.getGrantName().equals(this.getGrantName())) {
            return false;
        }
        if (other.getLicenseArn() == null ^ this.getLicenseArn() == null) {
            return false;
        }
        if (other.getLicenseArn() != null && !other.getLicenseArn().equals(this.getLicenseArn())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        if (other.getPrincipals() != null && !other.getPrincipals().equals(this.getPrincipals())) {
            return false;
        }
        if (other.getHomeRegion() == null ^ this.getHomeRegion() == null) {
            return false;
        }
        if (other.getHomeRegion() != null && !other.getHomeRegion().equals(this.getHomeRegion())) {
            return false;
        }
        if (other.getAllowedOperations() == null ^ this.getAllowedOperations() == null) {
            return false;
        }
        return other.getAllowedOperations() == null || other.getAllowedOperations().equals(this.getAllowedOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getGrantName() == null ? 0 : this.getGrantName().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseArn() == null ? 0 : this.getLicenseArn().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getHomeRegion() == null ? 0 : this.getHomeRegion().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedOperations() == null ? 0 : this.getAllowedOperations().hashCode());
        return hashCode;
    }

    public CreateGrantRequest clone() {
        return (CreateGrantRequest)super.clone();
    }
}

