/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.Disk;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetDisksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Disk> disks;
    private String nextPageToken;

    public List<Disk> getDisks() {
        return this.disks;
    }

    public void setDisks(Collection<Disk> disks) {
        if (disks == null) {
            this.disks = null;
            return;
        }
        this.disks = new ArrayList<Disk>(disks);
    }

    public GetDisksResult withDisks(Disk ... disks) {
        if (this.disks == null) {
            this.setDisks(new ArrayList<Disk>(disks.length));
        }
        for (Disk ele : disks) {
            this.disks.add(ele);
        }
        return this;
    }

    public GetDisksResult withDisks(Collection<Disk> disks) {
        this.setDisks(disks);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetDisksResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDisks() != null) {
            sb.append("Disks: ").append(this.getDisks()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDisksResult)) {
            return false;
        }
        GetDisksResult other = (GetDisksResult)obj;
        if (other.getDisks() == null ^ this.getDisks() == null) {
            return false;
        }
        if (other.getDisks() != null && !other.getDisks().equals(this.getDisks())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDisks() == null ? 0 : this.getDisks().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetDisksResult clone() {
        try {
            return (GetDisksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

