/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.Domain;
import com.amazonaws.services.lightsail.model.DomainEntry;
import com.amazonaws.services.lightsail.model.transform.DomainEntryJsonMarshaller;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonMarshaller;
import java.util.List;

public class DomainJsonMarshaller {
    private static DomainJsonMarshaller instance;

    public void marshall(Domain domain, StructuredJsonGenerator jsonGenerator) {
        if (domain == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<DomainEntry> domainEntriesList;
            jsonGenerator.writeStartObject();
            if (domain.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(domain.getName());
            }
            if (domain.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(domain.getArn());
            }
            if (domain.getSupportCode() != null) {
                jsonGenerator.writeFieldName("supportCode").writeValue(domain.getSupportCode());
            }
            if (domain.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(domain.getCreatedAt());
            }
            if (domain.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ResourceLocationJsonMarshaller.getInstance().marshall(domain.getLocation(), jsonGenerator);
            }
            if (domain.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(domain.getResourceType());
            }
            if ((domainEntriesList = domain.getDomainEntries()) != null) {
                jsonGenerator.writeFieldName("domainEntries");
                jsonGenerator.writeStartArray();
                for (DomainEntry domainEntriesListValue : domainEntriesList) {
                    if (domainEntriesListValue == null) continue;
                    DomainEntryJsonMarshaller.getInstance().marshall(domainEntriesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DomainJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DomainJsonMarshaller();
        }
        return instance;
    }
}

