/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Bucket;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class BucketMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<StructuredPojo> ACCESSRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessRules").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> OBJECTVERSIONING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectVersioning").build();
    private static final MarshallingInfo<Boolean> ABLETOUPDATEBUNDLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ableToUpdateBundle").build();
    private static final MarshallingInfo<List> READONLYACCESSACCOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readonlyAccessAccounts").build();
    private static final MarshallingInfo<List> RESOURCESRECEIVINGACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesReceivingAccess").build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<StructuredPojo> ACCESSLOGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessLogConfig").build();
    private static final BucketMarshaller instance = new BucketMarshaller();

    public static BucketMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bucket bucket, ProtocolMarshaller protocolMarshaller) {
        if (bucket == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bucket.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)bucket.getAccessRules(), ACCESSRULES_BINDING);
            protocolMarshaller.marshall((Object)bucket.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)bucket.getBundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)bucket.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)bucket.getUrl(), URL_BINDING);
            protocolMarshaller.marshall((Object)bucket.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)bucket.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)bucket.getSupportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall(bucket.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)bucket.getObjectVersioning(), OBJECTVERSIONING_BINDING);
            protocolMarshaller.marshall((Object)bucket.getAbleToUpdateBundle(), ABLETOUPDATEBUNDLE_BINDING);
            protocolMarshaller.marshall(bucket.getReadonlyAccessAccounts(), READONLYACCESSACCOUNTS_BINDING);
            protocolMarshaller.marshall(bucket.getResourcesReceivingAccess(), RESOURCESRECEIVINGACCESS_BINDING);
            protocolMarshaller.marshall((Object)bucket.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)bucket.getAccessLogConfig(), ACCESSLOGCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

