/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lookoutmetrics;

import javax.annotation.Generated;

import com.amazonaws.services.lookoutmetrics.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonLookoutMetrics}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLookoutMetrics implements AmazonLookoutMetrics {

    protected AbstractAmazonLookoutMetrics() {
    }

    @Override
    public ActivateAnomalyDetectorResult activateAnomalyDetector(ActivateAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BackTestAnomalyDetectorResult backTestAnomalyDetector(BackTestAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAlertResult createAlert(CreateAlertRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAnomalyDetectorResult createAnomalyDetector(CreateAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMetricSetResult createMetricSet(CreateMetricSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeactivateAnomalyDetectorResult deactivateAnomalyDetector(DeactivateAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAlertResult deleteAlert(DeleteAlertRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAnomalyDetectorResult deleteAnomalyDetector(DeleteAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAlertResult describeAlert(DescribeAlertRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAnomalyDetectionExecutionsResult describeAnomalyDetectionExecutions(DescribeAnomalyDetectionExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAnomalyDetectorResult describeAnomalyDetector(DescribeAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMetricSetResult describeMetricSet(DescribeMetricSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectMetricSetConfigResult detectMetricSetConfig(DetectMetricSetConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnomalyGroupResult getAnomalyGroup(GetAnomalyGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataQualityMetricsResult getDataQualityMetrics(GetDataQualityMetricsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFeedbackResult getFeedback(GetFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSampleDataResult getSampleData(GetSampleDataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAlertsResult listAlerts(ListAlertsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnomalyDetectorsResult listAnomalyDetectors(ListAnomalyDetectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnomalyGroupRelatedMetricsResult listAnomalyGroupRelatedMetrics(ListAnomalyGroupRelatedMetricsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnomalyGroupSummariesResult listAnomalyGroupSummaries(ListAnomalyGroupSummariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnomalyGroupTimeSeriesResult listAnomalyGroupTimeSeries(ListAnomalyGroupTimeSeriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMetricSetsResult listMetricSets(ListMetricSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutFeedbackResult putFeedback(PutFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAlertResult updateAlert(UpdateAlertRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnomalyDetectorResult updateAnomalyDetector(UpdateAnomalyDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMetricSetResult updateMetricSet(UpdateMetricSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
