/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListRelaysRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * If you received a pagination token from a previous call to this API, you can provide it here to continue
     * paginating through the next page of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The number of relays to be returned in one request.
     * </p>
     */
    private Integer pageSize;

    /**
     * <p>
     * If you received a pagination token from a previous call to this API, you can provide it here to continue
     * paginating through the next page of results.
     * </p>
     * 
     * @param nextToken
     *        If you received a pagination token from a previous call to this API, you can provide it here to continue
     *        paginating through the next page of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If you received a pagination token from a previous call to this API, you can provide it here to continue
     * paginating through the next page of results.
     * </p>
     * 
     * @return If you received a pagination token from a previous call to this API, you can provide it here to continue
     *         paginating through the next page of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If you received a pagination token from a previous call to this API, you can provide it here to continue
     * paginating through the next page of results.
     * </p>
     * 
     * @param nextToken
     *        If you received a pagination token from a previous call to this API, you can provide it here to continue
     *        paginating through the next page of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRelaysRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The number of relays to be returned in one request.
     * </p>
     * 
     * @param pageSize
     *        The number of relays to be returned in one request.
     */

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * <p>
     * The number of relays to be returned in one request.
     * </p>
     * 
     * @return The number of relays to be returned in one request.
     */

    public Integer getPageSize() {
        return this.pageSize;
    }

    /**
     * <p>
     * The number of relays to be returned in one request.
     * </p>
     * 
     * @param pageSize
     *        The number of relays to be returned in one request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRelaysRequest withPageSize(Integer pageSize) {
        setPageSize(pageSize);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getPageSize() != null)
            sb.append("PageSize: ").append(getPageSize());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListRelaysRequest == false)
            return false;
        ListRelaysRequest other = (ListRelaysRequest) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getPageSize() == null ^ this.getPageSize() == null)
            return false;
        if (other.getPageSize() != null && other.getPageSize().equals(this.getPageSize()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getPageSize() == null) ? 0 : getPageSize().hashCode());
        return hashCode;
    }

    @Override
    public ListRelaysRequest clone() {
        return (ListRelaysRequest) super.clone();
    }

}
